/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.primary;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.util.ConvertUtil;

public class LiteralSyntax
implements Syntax<Literal>,
QueryConstants {
    private static char QUOTE_CHAR = (char)39;
    private static char PLUS_CHAR = (char)43;
    private static char MINUS_CHAR = (char)45;
    private static char EXP_CAHR_U = (char)69;
    private static char EXP_CAHR_L = (char)101;
    private static final char INTEGER_SUFFIX_U = 'I';
    private static final char INTEGER_SUFFIX_L = 'i';
    private static final char FLOAT_SUFFIX_U = 'F';
    private static final char FLOAT_SUFFIX_L = 'f';
    private static final char DECIMAL_SUFFIX_U = 'G';
    private static final char DECIMAL_SUFFIX_L = 'g';
    private static final char TIME_SUFFIX_U = 'T';
    private static final char TIME_SUFFIX_L = 't';
    private static final char DATE_SUFFIX_U = 'D';
    private static final char DATE_SUFFIX_L = 'd';
    private static final char DATETIME_SUFFIX_U = 'M';
    private static final char DATETIME_SUFFIX_L = 'm';
    private static final char SELECT_SUFFIX_U = 'S';
    private static final char SELECT_SUFFIX_L = 's';

    @Override
    public void init(SyntaxContext context) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Literal parse(ParseContext str) throws ParseException {
        boolean isBind;
        Object val;
        block71: {
            block77: {
                String literalExp;
                int index;
                char peekChar;
                block81: {
                    char expSuffix;
                    String expStr;
                    block82: {
                        char suffix;
                        block80: {
                            block79: {
                                block78: {
                                    block72: {
                                        char nextChar;
                                        block76: {
                                            block75: {
                                                block74: {
                                                    block73: {
                                                        block70: {
                                                            val = null;
                                                            isBind = true;
                                                            if (str.startsWith("/*+")) {
                                                                str.consumeChars("/*+".length());
                                                                str.consumeChars(ParseContext.WHITE_SPACES);
                                                                if (!str.equalsNextToken("NO_BIND", ParseContext.TOKEN_DELIMITERS)) {
                                                                    throw new ParseException(new EvalError("only no_bind hint is valid.", this, str));
                                                                }
                                                                str.consumeChars("NO_BIND".length());
                                                                str.consumeChars(ParseContext.WHITE_SPACES);
                                                                isBind = false;
                                                                if (!str.startsWith("*/")) {
                                                                    throw new ParseException(new EvalError("hint clause not terminated.", this, str));
                                                                }
                                                                str.consumeChars("*/".length());
                                                                str.consumeChars(ParseContext.WHITE_SPACES);
                                                            }
                                                            if (!str.equalsNextToken("NULL", ParseContext.TOKEN_DELIMITERS)) break block70;
                                                            str.consumeChars("NULL".length());
                                                            val = null;
                                                            break block71;
                                                        }
                                                        peekChar = str.peekChar();
                                                        if (peekChar != QUOTE_CHAR) break block72;
                                                        val = str.innerToken(QUOTE_CHAR, true);
                                                        if (val == null) {
                                                            throw new ParseException(new EvalError("quoted string not terminated.", this, str));
                                                        }
                                                        nextChar = str.peekChar();
                                                        if (nextChar != 'T' && nextChar != 't') break block73;
                                                        val = ConvertUtil.convertFromString(Time.class, (String)val);
                                                        str.popChar();
                                                        break block71;
                                                    }
                                                    if (nextChar != 'D' && nextChar != 'd') break block74;
                                                    val = ConvertUtil.convertFromString(Date.class, (String)val);
                                                    str.popChar();
                                                    break block71;
                                                }
                                                if (nextChar != 'M' && nextChar != 'm') break block75;
                                                val = ConvertUtil.convertFromString(Timestamp.class, (String)val);
                                                str.popChar();
                                                break block71;
                                            }
                                            if (nextChar != 'S' && nextChar != 's') break block76;
                                            val = new SelectValue((String)val);
                                            str.popChar();
                                            break block71;
                                        }
                                        if (nextChar == 'G' || nextChar == 'g') {
                                            int index2 = str.getCurrentIndex();
                                            try {
                                                val = new BigDecimal((String)val);
                                            }
                                            catch (NumberFormatException e) {
                                                str.setCurrentIndex(index2);
                                                throw new ParseException(new EvalError("can not parse decimal(fixed-point) value.", this, str));
                                            }
                                            str.popChar();
                                        }
                                        break block71;
                                    }
                                    if (peekChar != PLUS_CHAR && peekChar != MINUS_CHAR) break block77;
                                    index = str.getCurrentIndex();
                                    str.consumeChars(1);
                                    literalExp = str.nextToken(ParseContext.TOKEN_DELIMITERS);
                                    if (literalExp == null) {
                                        str.setCurrentIndex(index);
                                        throw new ParseException(new EvalError("literal value expected.", this, str));
                                    }
                                    suffix = literalExp.charAt(literalExp.length() - 1);
                                    if (suffix != 'G' && suffix != 'g') break block78;
                                    try {
                                        if (peekChar == MINUS_CHAR) {
                                            val = new BigDecimal("-" + literalExp.substring(0, literalExp.length() - 1));
                                        }
                                        val = new BigDecimal(literalExp.substring(0, literalExp.length() - 1));
                                    }
                                    catch (NumberFormatException e) {
                                        str.setCurrentIndex(index);
                                        throw new ParseException(new EvalError("can not parse decimal(fixed-point) value.", this, str));
                                    }
                                }
                                if (suffix != 'F' && suffix != 'f') break block79;
                                try {
                                    if (peekChar == MINUS_CHAR) {
                                        val = Double.parseDouble("-" + literalExp.substring(0, literalExp.length() - 1));
                                    }
                                    val = Double.parseDouble(literalExp.substring(0, literalExp.length() - 1));
                                }
                                catch (NumberFormatException e) {
                                    str.setCurrentIndex(index);
                                    throw new ParseException(new EvalError("can not parse floating value.", this, str));
                                }
                            }
                            if (suffix != 'I' && suffix != 'i') break block80;
                            try {
                                if (peekChar == MINUS_CHAR) {
                                    val = Long.parseLong("-" + literalExp.substring(0, literalExp.length() - 1));
                                }
                                val = Long.parseLong(literalExp.substring(0, literalExp.length() - 1));
                            }
                            catch (NumberFormatException e) {
                                str.setCurrentIndex(index);
                                throw new ParseException(new EvalError("can not parse integer value.", this, str));
                            }
                        }
                        if (suffix != EXP_CAHR_U && suffix != EXP_CAHR_L) break block81;
                        if (str.peekChar() != MINUS_CHAR) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                        str.consumeChars(1);
                        expStr = str.nextToken(ParseContext.TOKEN_DELIMITERS);
                        if (expStr == null) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                        expSuffix = expStr.charAt(expStr.length() - 1);
                        if (expSuffix != 'G' && expSuffix != 'g') break block82;
                        try {
                            if (peekChar == MINUS_CHAR) {
                                val = new BigDecimal("-" + literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                            }
                            val = new BigDecimal(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    }
                    if (expSuffix == 'F' || expSuffix == 'f') {
                        try {
                            if (peekChar == MINUS_CHAR) {
                                val = Double.parseDouble("-" + literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                            }
                            val = Double.parseDouble(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    } else {
                        try {
                            if (peekChar == MINUS_CHAR) {
                                val = Double.parseDouble("-" + literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length()));
                            }
                            val = Double.parseDouble(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length()));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    }
                }
                if (literalExp.contains(".")) {
                    try {
                        if (peekChar == MINUS_CHAR) {
                            val = Double.parseDouble("-" + literalExp);
                        }
                        val = Double.parseDouble(literalExp);
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse floating value.", this, str));
                    }
                } else {
                    try {
                        if (peekChar == MINUS_CHAR) {
                            val = Long.parseLong("-" + literalExp);
                        }
                        val = Long.parseLong(literalExp);
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse integer value.", this, str));
                    }
                }
            }
            int index = str.getCurrentIndex();
            String literalExp = str.nextToken(ParseContext.TOKEN_DELIMITERS);
            if (literalExp == null) {
                str.setCurrentIndex(index);
                throw new ParseException(new EvalError("literal value expected.", this, str));
            }
            if (literalExp.equalsIgnoreCase("TRUE")) {
                val = Boolean.TRUE;
            } else if (literalExp.equalsIgnoreCase("FALSE")) {
                val = Boolean.FALSE;
            } else {
                char suffix = literalExp.charAt(literalExp.length() - 1);
                if (suffix == 'G' || suffix == 'g') {
                    try {
                        val = new BigDecimal(literalExp.substring(0, literalExp.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse decimal(fixed-point) value.", this, str));
                    }
                }
                if (suffix == 'F' || suffix == 'f') {
                    try {
                        val = Double.parseDouble(literalExp.substring(0, literalExp.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse floating value.", this, str));
                    }
                }
                if (suffix == 'I' || suffix == 'i') {
                    try {
                        val = Long.parseLong(literalExp.substring(0, literalExp.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse integer value.", this, str));
                    }
                }
                if (suffix == EXP_CAHR_U || suffix == EXP_CAHR_L) {
                    if (str.peekChar() != MINUS_CHAR) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                    }
                    str.consumeChars(1);
                    String expStr = str.nextToken(ParseContext.TOKEN_DELIMITERS);
                    if (expStr == null) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                    }
                    char expSuffix = expStr.charAt(expStr.length() - 1);
                    if (expSuffix == 'G' || expSuffix == 'g') {
                        try {
                            val = new BigDecimal(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    }
                    if (expSuffix == 'F' || expSuffix == 'f') {
                        try {
                            val = Double.parseDouble(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length() - 1));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    } else {
                        try {
                            val = Double.parseDouble(literalExp.substring(0, literalExp.length()) + "-" + expStr.substring(0, expStr.length()));
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse exponential value.", this, str));
                        }
                    }
                } else {
                    if (literalExp.contains(".")) {
                        try {
                            val = Double.parseDouble(literalExp);
                        }
                        catch (NumberFormatException e) {
                            str.setCurrentIndex(index);
                            throw new ParseException(new EvalError("can not parse floating value.", this, str));
                        }
                    }
                    try {
                        val = Long.parseLong(literalExp);
                    }
                    catch (NumberFormatException e) {
                        str.setCurrentIndex(index);
                        throw new ParseException(new EvalError("can not parse integer value.", this, str));
                    }
                }
            }
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        return new Literal(val, isBind);
    }
}

