/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.bulk;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.FixedExpressionColumnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedBulkInsertContext
implements BulkInsertContext {
    private static final Logger logger = LoggerFactory.getLogger(PreparedBulkInsertContext.class);
    private List<ColumnValue> columnValue;
    private PreparedStatement ps;
    private int currentSize;

    @Override
    public void setContext(String tableName, List<ColumnValue> columnValue, Connection con) throws SQLException {
        int i;
        this.columnValue = columnValue;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append("(");
        for (i = 0; i < columnValue.size(); ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(columnValue.get(i).colName());
        }
        sql.append(") VALUES(");
        for (i = 0; i < columnValue.size(); ++i) {
            ColumnValue cvm;
            if (i != 0) {
                sql.append(",");
            }
            if ((cvm = columnValue.get(i)) instanceof FixedExpressionColumnValue) {
                sql.append(((FixedExpressionColumnValue)cvm).fixedValueExpression());
                continue;
            }
            if (cvm instanceof DynamicColumnValue) {
                ((DynamicColumnValue)cvm).bindExpression(sql);
                continue;
            }
            throw new IllegalArgumentException();
        }
        sql.append(")");
        this.ps = con.prepareStatement(sql.toString());
    }

    @Override
    public void add(List<Object> values) throws SQLException {
        if (this.columnValue.size() != values.size()) {
            throw new IllegalArgumentException("val length not equals col length");
        }
        int index = 1;
        for (int i = 0; i < values.size(); ++i) {
            ColumnValue cvm = this.columnValue.get(i);
            if (cvm instanceof FixedExpressionColumnValue) continue;
            ((DynamicColumnValue)cvm).setParameter(values.get(i), index, this.ps);
            ++index;
        }
        this.ps.addBatch();
        ++this.currentSize;
    }

    @Override
    public void execute() throws SQLException {
        if (this.currentSize > 0) {
            this.ps.executeBatch();
            this.currentSize = 0;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.ps != null) {
            try {
                this.ps.clearBatch();
            }
            catch (SQLException e) {
                logger.error("cant clearBatch. caluse " + String.valueOf(e), (Throwable)e);
            }
            finally {
                this.ps.close();
            }
        }
    }

    @Override
    public int getCurrentSize() {
        return this.currentSize;
    }
}

