/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.function;

import java.util.List;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class AggregateFunctionAdapter<T extends Aggregate>
implements FunctionAdapter<T> {
    private String functionName;
    private String sqlFunctionName;
    private Class<?> type;

    public AggregateFunctionAdapter(String functionName, Class<?> type) {
        this(functionName, functionName, type);
    }

    public AggregateFunctionAdapter(String functionName, String sqlFunctionName, Class<?> type) {
        this.functionName = functionName;
        this.sqlFunctionName = sqlFunctionName;
        this.type = type;
    }

    public String getSqlFunctionName() {
        return this.sqlFunctionName;
    }

    public void setSqlFunctionName(String sqlFunctionName) {
        this.sqlFunctionName = sqlFunctionName;
    }

    @Override
    public Class<?> getType(T function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        if (this.type != null) {
            return this.type;
        }
        ValueExpression value = ((Aggregate)function).getValue();
        if (value != null) {
            return typeResolver.resolveType(value);
        }
        return null;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, T function, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        context.appendArgument(((Aggregate)function).getValue());
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.append(args.get(i));
            }
        }
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }
}

