/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.function;

import java.math.BigDecimal;
import java.util.List;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.function.BaseFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class DynamicTypedFunctionAdapter
extends BaseFunctionAdapter {
    private int[] typeArgIndex;

    public DynamicTypedFunctionAdapter(String functionName, int[] typeArgIndex) {
        super(functionName);
        this.typeArgIndex = typeArgIndex;
    }

    public DynamicTypedFunctionAdapter(String functionName, String sqlFunctionName, int[] typeArgIndex) {
        super(functionName, sqlFunctionName);
        this.typeArgIndex = typeArgIndex;
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        List<ValueExpression> args = function.getArguments();
        if (args == null) {
            return null;
        }
        Class<?> type = typeResolver.resolveType(this.getIfNotNull(args, this.typeArgIndex[0]));
        for (int i = 1; i < this.typeArgIndex.length && type != null; ++i) {
            type = this.whichType(typeResolver.resolveType(this.getIfNotNull(args, this.typeArgIndex[i])), type);
        }
        return type;
    }

    private ValueExpression getIfNotNull(List<ValueExpression> args, int index) {
        if (args.size() > index) {
            return args.get(index);
        }
        return null;
    }

    private Class<?> whichType(Class<?> type1, Class<?> type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1 == Double.class || type2 == Double.class) {
            return Double.class;
        }
        if (type1 == BigDecimal.class || type2 == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (type1 == Long.class || type2 == Long.class) {
            return Long.class;
        }
        if (type1 == String.class || type2 == String.class) {
            return String.class;
        }
        return null;
    }
}

