/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.common.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroup;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.AggregateFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class ListaggFunctionAdapter
extends AggregateFunctionAdapter<Listagg> {
    public ListaggFunctionAdapter() {
        super("LISTAGG", String.class);
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Listagg function, RdbAdapter rdb) {
        context.append("LISTAGG(");
        if (function.isDistinct()) {
            context.append("DISTINCT ");
        }
        context.appendArgument(function.getValue());
        if (function.getSeparator() != null) {
            context.append(",");
            context.appendArgument(function.getSeparator());
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
        this.toWithinGroupSQL(context, function.getWithinGroup());
    }

    protected void toWithinGroupSQL(FunctionAdapter.FunctionContext context, WithinGroup wg) {
        if (wg != null) {
            context.append(" WITHIN GROUP(ORDER BY ");
            for (int i = 0; i < wg.getSortSpecList().size(); ++i) {
                if (i > 0) {
                    context.append(",");
                }
                this.toOrderBySpecSQL(context, wg.getSortSpecList().get(i));
            }
            context.append(")");
        }
    }

    protected void toOrderBySpecSQL(FunctionAdapter.FunctionContext context, WithinGroupSortSpec ss) {
        context.appendArgument(ss.getSortKey());
        if (ss.getType() != null) {
            context.append(" ");
            context.append(ss.getType().toString());
        }
        if (ss.getNullOrderingSpec() != null) {
            context.append(" NULLS ");
            context.append(ss.getNullOrderingSpec().toString());
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args.size() != 4) {
            throw new QueryException("LISTAGG argment mismatch.");
        }
        context.append("LISTAGG(");
        if (args.get(0) != null) {
            context.append(args.get(0));
            context.append(" ");
        }
        context.append(args.get(1));
        if (args.get(2) != null) {
            context.append(",'");
            context.append(args.get(2));
            context.append("'");
        } else if (rdb.getListaggDefaultSeparator() != null) {
            context.append(",'");
            context.append(rdb.getListaggDefaultSeparator());
            context.append("'");
        }
        context.append(")");
        if (args.get(3) != null) {
            context.append(" WITHIN GROUP(ORDER BY ");
            context.append(args.get(3));
            context.append(")");
        }
    }
}

