/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.common.function;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class LocalTimeFunctionAdapter
implements FunctionAdapter<Function> {
    @Override
    public String getFunctionName() {
        return "LOCALTIME";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Timestamp.class;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        String[] convertTZ = rdb.convertTZ(ExecuteContext.getCurrentContext().getTimeZone().getID());
        context.append(convertTZ[0]);
        if (function.getArguments() == null || function.getArguments().size() != 1) {
            throw new QueryException(function.getName() + " must have only one arguments.");
        }
        context.appendArgument(function.getArguments().get(0));
        context.append(convertTZ[1]);
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        String[] convertTZ = rdb.convertTZ(ExecuteContext.getCurrentContext().getTimeZone().getID());
        context.append(convertTZ[0]);
        if (args == null || args.size() != 1) {
            throw new QueryException(this.getFunctionName() + " must have only one arguments.");
        }
        context.append(args.get(0));
        context.append(convertTZ[1]);
    }
}

