/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.iplass.mtp.impl.rdb.connection.AbstractConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConnectionFactory
extends AbstractConnectionFactory {
    public static final String DEFAULT_DATA_SOURCE_JNDI_NAME = "java:comp/env/jdbc/defaultDS";
    private static final String JNDI_ENV_PREFIX = "jndienv.";
    private static Logger logger = LoggerFactory.getLogger(DataSourceConnectionFactory.class);
    private DataSource dataSource;
    private boolean directCreate;
    private Hashtable<String, Object> jndiEnv = new Hashtable();

    @Override
    protected Connection getConnectionInternal() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionException("can not get DataSource Connection:", e);
        }
    }

    @Override
    public void destroy() {
        if (this.directCreate) {
            try {
                if (this.dataSource instanceof Closeable) {
                    ((Closeable)((Object)this.dataSource)).close();
                } else if (this.dataSource instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)this.dataSource)).close();
                }
            }
            catch (Exception e) {
                logger.warn("error in DataSourceConnectionFactory#destroy()" + String.valueOf(e), (Throwable)e);
            }
        }
        this.dataSource = null;
    }

    @Override
    public void init(Config config) {
        super.init(config);
        for (String n : config.getNames()) {
            if (!n.startsWith(JNDI_ENV_PREFIX)) continue;
            this.jndiEnv.put(n.substring(JNDI_ENV_PREFIX.length()), config.getValue(n));
        }
        this.dataSource = config.getValue("dataSource", DataSource.class);
        if (this.dataSource != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("create DataSource directly. DataSource class:" + this.dataSource.getClass().getName());
            }
            this.directCreate = true;
        } else {
            String dsName = DEFAULT_DATA_SOURCE_JNDI_NAME;
            if (config.getValue("dataSourceName") != null) {
                dsName = config.getValue("dataSourceName");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("look up DataSource from JNDI. name:" + dsName);
            }
            InitialContext context = null;
            try {
                context = this.getInitialContext();
                this.dataSource = (DataSource)context.lookup(dsName);
            }
            catch (NamingException e) {
                throw new ConnectionException("can not create DataSource:" + dsName, e);
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        logger.warn("InitialContext.close() fail.maybe leak... " + String.valueOf(e), (Throwable)e);
                    }
                }
            }
        }
    }

    protected InitialContext getInitialContext() throws NamingException {
        if (this.jndiEnv.size() > 0) {
            return new InitialContext(this.jndiEnv);
        }
        return new InitialContext();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

