/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.iplass.mtp.impl.rdb.connection.ReplicationAwareDataSourceConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationAwareConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(ReplicationAwareConnection.class);
    private ReplicationAwareDataSourceConnectionFactory conFactory;
    private Function<Connection, Connection> afterGetPhysicalConnectionHandler;
    private Connection con;
    private boolean readOnly;
    private boolean autoCommit = true;
    private boolean close;

    ReplicationAwareConnection(ReplicationAwareDataSourceConnectionFactory conFactory, Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        this.conFactory = conFactory;
        this.afterGetPhysicalConnectionHandler = afterGetPhysicalConnectionHandler;
    }

    private Connection getCon() throws SQLException {
        if (this.close) {
            throw new SQLException("Connection is closed");
        }
        if (this.con == null) {
            if (this.readOnly) {
                this.con = this.conFactory.getReplicaConnectionInternal();
                if (logger.isDebugEnabled()) {
                    logger.debug("Create Pysical Connection from replicaDataSource:" + String.valueOf(this));
                }
            } else {
                this.con = this.conFactory.getConnectionInternal();
                if (logger.isDebugEnabled()) {
                    logger.debug("Create Pysical Connection from dataSource:" + String.valueOf(this));
                }
            }
            this.conFactory.initPhysicalConnection(this.con, this.afterGetPhysicalConnectionHandler);
            this.con.setAutoCommit(this.autoCommit);
            this.con.setReadOnly(this.readOnly);
        }
        return this.con;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getCon().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getCon().isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.getCon().createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getCon().prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.getCon().prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getCon().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.con != null) {
            this.getCon().setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.con == null) {
            return this.autoCommit;
        }
        return this.getCon().getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        if (this.con != null) {
            this.getCon().commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.con != null) {
            this.getCon().rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        this.close = true;
        if (this.con != null) {
            this.con.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.con == null) {
            return this.close;
        }
        return this.con.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getCon().getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.con == null) {
            this.readOnly = readOnly;
        } else {
            this.getCon().setReadOnly(readOnly);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.con == null) {
            return this.readOnly;
        }
        return this.getCon().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getCon().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getCon().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getCon().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getCon().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.con != null) {
            return this.getCon().getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.con != null) {
            this.getCon().clearWarnings();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getCon().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getCon().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getCon().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getCon().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getCon().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getCon().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getCon().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.getCon().setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.getCon().setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getCon().rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getCon().releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getCon().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getCon().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getCon().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getCon().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.getCon().prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.getCon().prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getCon().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getCon().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getCon().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getCon().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getCon().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getCon().setClientInfo(name, value);
        }
        catch (SQLException e) {
            throw new SQLClientInfoException("Failed Create Connecton on setClientInfo()", Collections.singletonMap(name, ClientInfoStatus.REASON_UNKNOWN), (Throwable)e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getCon().setClientInfo(properties);
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> ci = new HashMap<String, ClientInfoStatus>();
            if (properties != null) {
                for (Object k : properties.keySet()) {
                    ci.put((String)k, ClientInfoStatus.REASON_UNKNOWN);
                }
            }
            throw new SQLClientInfoException("Failed Create Connecton on setClientInfo()", ci, (Throwable)e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getCon().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getCon().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getCon().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getCon().createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.getCon().setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCon().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getCon().abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.getCon().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getCon().getNetworkTimeout();
    }

    public String toString() {
        return "ReplicationAwareConnection@" + Integer.toHexString(this.hashCode()) + " [readOnly=" + this.readOnly + ", wrapped=" + String.valueOf(this.con) + "]";
    }
}

