/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import org.iplass.mtp.impl.rdb.connection.AbstractConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHolder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHolder.class);
    private static final ThreadLocal<ResourceHolder> holder = new ThreadLocal();
    private Connection connection;
    private boolean inUse = false;

    public static ResourceHolder getResourceHolder() {
        ResourceHolder r = holder.get();
        return r;
    }

    public static boolean init() {
        ResourceHolder r = holder.get();
        if (r == null) {
            r = new ResourceHolder();
            holder.set(r);
            return true;
        }
        return false;
    }

    public static void fin() {
        ResourceHolder r = holder.get();
        if (r != null) {
            r.finallyProcess();
            holder.remove();
        }
    }

    private ResourceHolder() {
    }

    public boolean isInUse() {
        return this.inUse;
    }

    Connection getConnection(AbstractConnectionFactory conFactory, Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        if (this.connection == null) {
            this.connection = conFactory.getPhysicalConnection(afterGetPhysicalConnectionHandler);
        }
        if (this.inUse) {
            throw new IllegalStateException("ResourceHolder's Connection allready in use");
        }
        this.inUse = true;
        return this.connection;
    }

    void releaseConnection(Connection con) {
        if (con != this.connection) {
            throw new IllegalStateException("ResourceHolder's Connection unmatch!");
        }
        this.inUse = false;
    }

    public void finallyProcess() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("close physical connection:" + String.valueOf(this.connection));
                }
                this.connection.close();
            }
        }
        catch (SQLException e) {
            logger.error("can't close Connection, maybe resource leak... :" + e.toString(), (Throwable)e);
        }
        this.connection = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.finallyProcess();
    }

    public String toString() {
        return super.toString() + "[connection=" + String.valueOf(this.connection) + "]";
    }
}

