/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.postgresql.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.DateTimeUnit;

public class PostgreSQLDateDiffFunctionAdapter
implements FunctionAdapter<Function>,
DateTimeUnit {
    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        String unit;
        if (function.getArguments() == null || function.getArguments().size() != 3) {
            throw new QueryException(function.getName() + " must have 3 arguments.");
        }
        switch (unit = ((String)((Literal)function.getArguments().get(0)).getValue()).toUpperCase()) {
            case "YEAR": {
                context.append("EXTRACT(YEAR FROM AGE(");
                context.appendArgument(function.getArguments().get(2));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append("))");
                break;
            }
            case "MONTH": {
                context.append("(EXTRACT(YEAR FROM AGE(");
                context.appendArgument(function.getArguments().get(2));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append("))*12+EXTRACT(MONTH FROM AGE(");
                context.appendArgument(function.getArguments().get(2));
                context.append(",");
                context.appendArgument(function.getArguments().get(1));
                context.append(")))");
                break;
            }
            case "DAY": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS TIMESTAMP))/86400)");
                break;
            }
            case "HOUR": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS TIMESTAMP))/3600)");
                break;
            }
            case "MINUTE": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS TIMESTAMP))/60)");
                break;
            }
            case "SECOND": {
                context.append("EXTRACT(EPOCH FROM CAST((");
                context.appendArgument(function.getArguments().get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.appendArgument(function.getArguments().get(1));
                context.append(") AS TIMESTAMP))");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        String unit;
        if (args == null || args.size() != 3) {
            throw new QueryException(this.getFunctionName() + " must have 3 arguments.");
        }
        switch (unit = args.get(0).toString().toUpperCase()) {
            case "YEAR": {
                context.append("EXTRACT(YEAR FROM AGE(");
                context.append(args.get(2));
                context.append(",");
                context.append(args.get(1));
                context.append("))");
                break;
            }
            case "MONTH": {
                context.append("(EXTRACT(YEAR FROM AGE(");
                context.append(args.get(2));
                context.append(",");
                context.append(args.get(1));
                context.append("))*12+EXTRACT(MONTH FROM AGE(");
                context.append(args.get(2));
                context.append(",");
                context.append(args.get(1));
                context.append(")))");
                break;
            }
            case "DAY": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.append(args.get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.append(args.get(1));
                context.append(") AS TIMESTAMP))/86400)");
                break;
            }
            case "HOUR": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.append(args.get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.append(args.get(1));
                context.append(") AS TIMESTAMP))/3600)");
                break;
            }
            case "MINUTE": {
                context.append("TRUNC(EXTRACT(EPOCH FROM CAST((");
                context.append(args.get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.append(args.get(1));
                context.append(") AS TIMESTAMP))/60)");
                break;
            }
            case "SECOND": {
                context.append("EXTRACT(EPOCH FROM CAST((");
                context.append(args.get(2));
                context.append(") AS TIMESTAMP)-CAST((");
                context.append(args.get(1));
                context.append(") AS TIMESTAMP))");
                break;
            }
            default: {
                throw new QueryException("unknown interval unit:" + unit);
            }
        }
    }

    @Override
    public String getFunctionName() {
        return "DATE_DIFF";
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Long.class;
    }
}

