/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class SqlServerExtractDateFunctionAdapter
implements FunctionAdapter<Function> {
    private String field;

    public SqlServerExtractDateFunctionAdapter(String field) {
        this.field = field;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        context.append("DATEPART(");
        context.append(this.field);
        context.append(" , ");
        if (function.getArguments() == null || function.getArguments().size() != 1) {
            throw new QueryException(function.getName() + " must have only one arguments.");
        }
        context.appendArgument(function.getArguments().get(0));
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        context.append("DATEPART(");
        context.append(this.field);
        context.append(" , ");
        if (args == null || args.size() != 1) {
            throw new QueryException(this.getFunctionName() + " must have only one arguments.");
        }
        context.append(args.get(0));
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return this.field;
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Long.class;
    }
}

