/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.RoundTruncFunctionAdapter;

public class SqlServerRoundFunctionAdapter
extends RoundTruncFunctionAdapter {
    private static final String SQL_FUNCTION_NAME = "ROUND";

    public SqlServerRoundFunctionAdapter(String field) {
        super(field, SQL_FUNCTION_NAME);
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        context.append(SQL_FUNCTION_NAME);
        context.append("(");
        if (function.getArguments() != null) {
            for (int i = 0; i < function.getArguments().size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.appendArgument(function.getArguments().get(i));
            }
        }
        if (function.getArguments().size() == 1) {
            context.append(",0");
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        context.append(SQL_FUNCTION_NAME);
        context.append("(");
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.append(args.get(i));
            }
        }
        if (args.size() == 1) {
            context.append(",0");
        }
        context.append(")");
    }
}

