/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.GroovyObjectInputStream;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyObjectSerializeWrapper
implements Serializable {
    private static final long serialVersionUID = 5102391278876534117L;
    private static Logger logger = LoggerFactory.getLogger(GroovyObjectSerializeWrapper.class);
    private byte[] byteData;
    private volatile transient GroovyObject object;

    public GroovyObjectSerializeWrapper(GroovyObject object) {
        this.object = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyObject getObject() {
        GroovyObject obj = this.object;
        if (obj != null) {
            GroovyScriptEngine gse = (GroovyScriptEngine)ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            if (((GroovyClassLoader.InnerLoader)obj.getClass().getClassLoader()).getParent() != gse.getSharedClassLoader()) {
                GroovyObjectSerializeWrapper groovyObjectSerializeWrapper = this;
                synchronized (groovyObjectSerializeWrapper) {
                    if (this.object != null && ((GroovyClassLoader.InnerLoader)this.object.getClass().getClassLoader()).getParent() != gse.getSharedClassLoader()) {
                        byte[] copyByte = this.serializeObject(obj);
                        try {
                            obj = this.deserializeObject(copyByte);
                        }
                        catch (Exception e) {
                            logger.error("cant deserialize GroovyObject... so return null.", (Throwable)e);
                            obj = null;
                        }
                        this.object = obj;
                    }
                }
            }
            return obj;
        }
        GroovyObjectSerializeWrapper groovyObjectSerializeWrapper = this;
        synchronized (groovyObjectSerializeWrapper) {
            if (this.byteData != null) {
                try {
                    this.object = this.deserializeObject(this.byteData);
                }
                catch (Exception e) {
                    logger.error("cant deserialize GroovyObject... so return null.", (Throwable)e);
                }
                this.byteData = null;
            }
        }
        return this.object;
    }

    private GroovyObject deserializeObject(byte[] dat) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(dat);){
            GroovyObject groovyObject;
            try (GroovyObjectInputStream in = new GroovyObjectInputStream(byteIn);){
                groovyObject = (GroovyObject)in.readObject();
            }
            return groovyObject;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeObject(Object obj) {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(byteOut);){
                oos.writeObject(this.object);
                byArray = byteOut.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.byteData = this.serializeObject(this.object);
        out.defaultWriteObject();
    }
}

