/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.script.GroovyScript;
import org.iplass.mtp.impl.script.GroovyScriptContext;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.MetaUtilityClass;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinition;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyScriptService
extends AbstractTypedMetaDataService<MetaUtilityClass, MetaUtilityClass.UtilityClassRuntime>
implements ScriptService {
    private static Logger logger = LoggerFactory.getLogger(GroovyScriptService.class);
    private static final String ENCODING = "UTF-8";
    public static final String UTILITY_CLASS_META_PATH = "/utilityClass/";
    private static final String TRANSACTION_FLAG_KEY = "mtp.script.invalidateTenantContext";
    private GroovyClassLoader parentClassLoader;
    private List<GroovyScript> expandScriptRefs;
    private List<String> initScript;
    private List<String> importList;
    private List<String> staticImportList;
    private boolean debug;

    private String getScriptSrc(String path) {
        InputStream is = GroovyScriptService.class.getResourceAsStream(path);
        byte[] buf = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = is.read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            os.flush();
            String string = os.toString(ENCODING);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("can not close resource:" + path + ". may be reak...");
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        ExpandoMetaClass.enableGlobally();
        if (config.getValue("debug") != null) {
            this.debug = Boolean.valueOf(config.getValue("debug"));
        }
        this.importList = config.getValues("import");
        this.staticImportList = config.getValues("staticImport");
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.setSourceEncoding(ENCODING);
        if (this.debug) {
            conf.setVerbose(true);
            conf.setDebug(true);
        }
        this.parentClassLoader = new GroovyClassLoader(GroovyScriptService.class.getClassLoader(), conf, false);
        this.initScript = config.getValues("initScript");
        if (this.initScript != null) {
            this.expandScriptRefs = new ArrayList<GroovyScript>();
            for (int i = 0; i < this.initScript.size(); ++i) {
                String src = this.getScriptSrc(this.initScript.get(i));
                GroovyScript expandScriptRef = new GroovyScript(this.parentClassLoader, src, "___initScript_" + i + "___");
                expandScriptRef.eval(new GroovyScriptContext());
                this.expandScriptRefs.add(expandScriptRef);
            }
        }
    }

    public static String getFixedPath() {
        return UTILITY_CLASS_META_PATH;
    }

    public boolean isDebug() {
        return this.debug;
    }

    private CompilerConfiguration newCompilerConfiguration() {
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.setSourceEncoding(ENCODING);
        if (this.debug) {
            conf.setVerbose(true);
            conf.setDebug(true);
        }
        ImportCustomizer ic = null;
        if (this.importList != null && this.importList.size() > 0) {
            ic = new ImportCustomizer();
            for (String i : this.importList) {
                if ((i = i.trim()).endsWith(".*")) {
                    ic.addStarImports(new String[]{i.substring(0, i.length() - 2)});
                    continue;
                }
                ic.addImports(new String[]{i});
            }
        }
        if (this.staticImportList != null && this.staticImportList.size() > 0) {
            if (ic == null) {
                ic = new ImportCustomizer();
            }
            for (String si : this.staticImportList) {
                if ((si = si.trim()).endsWith(".*")) {
                    ic.addStaticStars(new String[]{si.substring(0, si.length() - 2)});
                    continue;
                }
                int dot = si.lastIndexOf(46);
                ic.addStaticImport(si.substring(0, dot), si.substring(dot + 1));
            }
        }
        if (ic != null) {
            conf.addCompilationCustomizers(new CompilationCustomizer[]{ic});
        }
        return conf;
    }

    @Override
    public ScriptEngine createScriptEngine() {
        return this.createScriptEngine(false);
    }

    public ScriptEngine createScriptEngine(boolean vanilla) {
        return new GroovyScriptEngine(new GroovyClassLoader((ClassLoader)this.parentClassLoader, this.newCompilerConfiguration(), false), this, vanilla);
    }

    @Override
    public void updateMetaData(MetaUtilityClass meta) {
        super.updateMetaData(meta);
        this.invalidateTenantContext();
    }

    @Override
    public void removeMetaData(String definitionName) {
        super.removeMetaData(definitionName);
        this.invalidateTenantContext();
    }

    private void invalidateTenantContext() {
        final TenantContext current = ExecuteContext.getCurrentContext().getTenantContext();
        Transaction t = Transaction.getCurrent();
        if (t.getStatus() == TransactionStatus.ACTIVE) {
            if (t.getAttribute(TRANSACTION_FLAG_KEY) == null) {
                t.addTransactionListener(new TransactionListener(){

                    @Override
                    public void afterCommit(Transaction t) {
                        TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
                        tcService.reloadTenantContext(current.getTenantId(), false);
                    }
                });
            }
        } else {
            TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
            tcService.reloadTenantContext(current.getTenantId(), false);
        }
    }

    @Override
    public Class<MetaUtilityClass> getMetaDataType() {
        return MetaUtilityClass.class;
    }

    @Override
    public Class<MetaUtilityClass.UtilityClassRuntime> getRuntimeType() {
        return MetaUtilityClass.UtilityClassRuntime.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<UtilityClassDefinition, MetaUtilityClass> {
        public TypeMap() {
            super(GroovyScriptService.getFixedPath(), MetaUtilityClass.class, UtilityClassDefinition.class);
        }

        @Override
        public TypedDefinitionManager<UtilityClassDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(UtilityClassDefinitionManager.class);
        }

        @Override
        public String toPath(String defName) {
            return this.pathPrefix + defName.replace('.', '/');
        }

        @Override
        public String toDefName(String path) {
            return path.substring(this.pathPrefix.length()).replace("/", ".");
        }
    }
}

