/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.GroovyBugError;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.script.GroovyScript;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinition;

public class MetaUtilityClass
extends BaseRootMetaData
implements DefinableMetaData<UtilityClassDefinition> {
    private static final long serialVersionUID = 3358601853577028302L;
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MetaUtilityClass copy() {
        MetaUtilityClass copy = new MetaUtilityClass();
        copy.id = this.id;
        copy.name = this.name;
        copy.displayName = this.displayName;
        copy.description = this.description;
        copy.script = this.script;
        return copy;
    }

    @Override
    public UtilityClassDefinition currentConfig() {
        UtilityClassDefinition def = new UtilityClassDefinition();
        def.setName(this.name);
        def.setDisplayName(this.displayName);
        def.setDescription(this.description);
        def.setScript(this.script);
        return def;
    }

    @Override
    public void applyConfig(UtilityClassDefinition definition) {
        this.name = this.convertName(definition.getName());
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.script = definition.getScript();
    }

    @Override
    public UtilityClassRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new UtilityClassRuntime();
    }

    private String convertName(String name) {
        return name.replace("/", ".");
    }

    public class UtilityClassRuntime
    extends BaseMetaDataRuntime {
        @Override
        public void checkState() throws MetaDataIllegalStateException {
            try {
                if (MetaUtilityClass.this.script != null) {
                    TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                    GroovyScriptEngine gse = (GroovyScriptEngine)tc.getScriptEngine();
                    GroovyClassLoader tempcl = new GroovyClassLoader(gse.getSharedClassLoader());
                    new GroovyScript(tempcl, MetaUtilityClass.this.script, MetaUtilityClass.this.name);
                    tempcl.clearCache();
                }
            }
            catch (RuntimeException e) {
                throw new MetaDataIllegalStateException(e.getMessage(), e);
            }
            catch (NoClassDefFoundError | GroovyBugError e) {
                throw new MetaDataIllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public MetaUtilityClass getMetaData() {
            return MetaUtilityClass.this;
        }
    }
}

