/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.GroovyResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashSet;
import org.iplass.mtp.impl.script.GroovyScriptService;
import org.iplass.mtp.impl.script.MetaUtilityClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilitiyClassResourceLoader
implements GroovyResourceLoader {
    private static Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.classloader");
    private final GroovyResourceLoader parentResourceLoader;
    private final GroovyScriptService service;
    private HashSet<String> utilityClassNames;

    public UtilitiyClassResourceLoader(GroovyResourceLoader parentResourceLoader, GroovyScriptService service) {
        this.parentResourceLoader = parentResourceLoader;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL loadGroovySource(String name) throws MalformedURLException {
        boolean isMeta = false;
        UtilitiyClassResourceLoader utilitiyClassResourceLoader = this;
        synchronized (utilitiyClassResourceLoader) {
            if (this.utilityClassNames == null) {
                try {
                    this.utilityClassNames = new HashSet<String>(this.service.nameList());
                }
                catch (Exception e) {
                    fatalLog.error("utility class list loading process faild... " + String.valueOf(e), (Throwable)e);
                }
                catch (Error e) {
                    fatalLog.error("utility class list loading process faild... " + String.valueOf(e), (Throwable)e);
                    throw e;
                }
            }
            isMeta = this.utilityClassNames != null && this.utilityClassNames.contains(name);
        }
        if (!isMeta) {
            return this.parentResourceLoader.loadGroovySource(name);
        }
        return new URL(null, "metadata://utilityclass/" + name, new PreLoadStreamHandler(this.service, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearClassNameList() {
        UtilitiyClassResourceLoader utilitiyClassResourceLoader = this;
        synchronized (utilitiyClassResourceLoader) {
            this.utilityClassNames = null;
        }
    }

    private static class PreLoadStreamHandler
    extends URLStreamHandler {
        private String source;
        private Throwable error;

        public PreLoadStreamHandler(GroovyScriptService service, String name) {
            MetaUtilityClass.UtilityClassRuntime ucr = null;
            try {
                ucr = (MetaUtilityClass.UtilityClassRuntime)service.getRuntimeByName(name);
            }
            catch (Exception e) {
                fatalLog.error("utility class:" + name + " cant load. maybe need Reload or restart." + String.valueOf(e), (Throwable)e);
                this.error = new IOException(name + " cant read from UtilityMetaData:" + String.valueOf(e), e);
            }
            catch (Error e) {
                fatalLog.error("utility class:" + name + " cant load. maybe need Reload or restart." + String.valueOf(e), (Throwable)e);
                this.error = e;
            }
            if (ucr == null || ucr.getMetaData() == null || ucr.getMetaData().getScript() == null) {
                fatalLog.error("utility class:" + name + " cant load(metaData or script is null...). maybe need Reload or restart.");
                this.error = new IOException(name + " not found or no script...");
            }
            this.source = ucr.getMetaData().getScript();
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new PreLoadConnection(u);
        }

        private class PreLoadConnection
        extends URLConnection {
            PreLoadConnection(URL u) throws IOException {
                super(u);
            }

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                if (PreLoadStreamHandler.this.error != null) {
                    if (PreLoadStreamHandler.this.error instanceof IOException) {
                        throw (IOException)PreLoadStreamHandler.this.error;
                    }
                    if (PreLoadStreamHandler.this.error instanceof Error) {
                        throw (Error)PreLoadStreamHandler.this.error;
                    }
                    throw new IOException(PreLoadStreamHandler.this.error);
                }
                return new ByteArrayInputStream(PreLoadStreamHandler.this.source.getBytes("UTF-8"));
            }
        }
    }

    @Deprecated
    private static class Connection
    extends URLConnection {
        private final GroovyScriptService service;

        public Connection(URL u, GroovyScriptService service) throws IOException {
            super(u);
            this.service = service;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            MetaUtilityClass.UtilityClassRuntime ucr;
            try {
                ucr = (MetaUtilityClass.UtilityClassRuntime)this.service.getRuntimeByName(this.getURL().getPath().substring(1));
            }
            catch (Exception e) {
                fatalLog.error("utility class:" + this.getURL().getPath() + " cant load. maybe need Reload or restart." + String.valueOf(e), (Throwable)e);
                throw new IOException(this.getURL().getPath() + " cant read from UtilityMetaData:" + String.valueOf(e), e);
            }
            catch (Error e) {
                fatalLog.error("utility class:" + this.getURL().getPath() + " cant load. maybe need Reload or restart." + String.valueOf(e), (Throwable)e);
                throw e;
            }
            if (ucr == null || ucr.getMetaData() == null || ucr.getMetaData().getScript() == null) {
                fatalLog.error("utility class:" + this.getURL().getPath() + " cant load(metaData or script is null...). maybe need Reload or restart.");
                throw new IOException(this.getURL().getPath() + " not found or no script...");
            }
            return new ByteArrayInputStream(ucr.getMetaData().getScript().getBytes("UTF-8"));
        }
    }

    @Deprecated
    private static class StreamHandler
    extends URLStreamHandler {
        private final GroovyScriptService service;

        public StreamHandler(GroovyScriptService service) {
            this.service = service;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new Connection(u, this.service);
        }
    }
}

