/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script.template;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.template.GTmplBase;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyTemplateCompiler {
    private static Logger logger = LoggerFactory.getLogger(GroovyTemplateCompiler.class);
    private static KeyGenerator keyGen = new KeyGenerator();

    private static boolean isSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12 || c == 8;
    }

    public static String randomName() {
        return keyGen.generateId();
    }

    public static GroovyTemplate compile(String templateCode, String templateName, GroovyScriptEngine scriptEngine) {
        return GroovyTemplateCompiler.compile(templateCode, templateName, GTmplBase.class.getName(), scriptEngine);
    }

    public static GroovyTemplate compile(String templateCode, String templateName, String baseClassName, GroovyScriptEngine scriptEngine) {
        String groovyCode;
        templateName = templateName.replaceAll("[^\\w\\d]", "_");
        try {
            groovyCode = GroovyTemplateCompiler.parseToScript(new StringReader(templateCode), templateName, baseClassName);
            if (logger.isDebugEnabled()) {
                logger.debug("translate " + templateName + " to script...\n==========================\n" + groovyCode + "\n==========================");
            }
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
        Script script = scriptEngine.createScript(groovyCode, templateName);
        return new GroovyTemplate(script);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseToScript(Reader templateCode, String templateName, String baseClassName) throws IOException {
        StringBuilder templateSection;
        StringBuilder importSection;
        StringBuilder templateExpressions;
        block36: {
            templateExpressions = new StringBuilder("package org.iplass.mtp.tmp.templates;\n");
            importSection = new StringBuilder();
            templateSection = new StringBuilder();
            templateSection.append("class ").append(templateName);
            if (baseClassName != null) {
                templateSection.append(" extends ").append(baseClassName);
            }
            templateSection.append(" {\n def getTemplate() { return { out -> out << \"\"\"");
            boolean writingString = true;
            boolean isComment = false;
            int bc = -1;
            int c = -1;
            while (true) {
                block37: {
                    bc = c;
                    c = templateCode.read();
                    if (c == -1) {
                        if (writingString) {
                            break;
                        }
                        break block36;
                    }
                    if (isComment) {
                        if (c != 45 || (c = templateCode.read()) != 45 || (c = templateCode.read()) != 37 || (c = templateCode.read()) != 62) continue;
                        isComment = false;
                        continue;
                    }
                    if (c == 60) {
                        c = templateCode.read();
                        if (c == 37) {
                            c = templateCode.read();
                            if (c == 61) {
                                GroovyTemplateCompiler.parseExpression(templateCode, writingString, templateSection);
                                writingString = true;
                                continue;
                            }
                            if (c == 64) {
                                GroovyTemplateCompiler.parseImport(templateCode, importSection);
                                continue;
                            }
                            if (c == 45) {
                                c = templateCode.read();
                                if (c == 45) {
                                    isComment = true;
                                    continue;
                                }
                                GroovyTemplateCompiler.appendCharacter('<', templateSection, writingString);
                                writingString = true;
                                GroovyTemplateCompiler.appendCharacter('%', templateSection, writingString);
                                writingString = true;
                                GroovyTemplateCompiler.appendCharacter('-', templateSection, writingString);
                                writingString = true;
                                break block37;
                            } else {
                                GroovyTemplateCompiler.parseSection(c, templateCode, writingString, templateSection);
                                writingString = false;
                                continue;
                            }
                        }
                        GroovyTemplateCompiler.appendCharacter('<', templateSection, writingString);
                        writingString = true;
                    } else if (c == 34) {
                        GroovyTemplateCompiler.appendCharacter('\\', templateSection, writingString);
                        writingString = true;
                    } else if (c == 36) {
                        GroovyTemplateCompiler.appendCharacter('$', templateSection, writingString);
                        writingString = true;
                        c = templateCode.read();
                        if (c == 123) {
                            GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                            templateSection.append("nte{->");
                            GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                            templateSection.append("}}");
                            writingString = true;
                            continue;
                        }
                        if (c == 104) {
                            c = templateCode.read();
                            if (bc == 92) {
                                GroovyTemplateCompiler.appendCharacter('h', templateSection, writingString);
                            }
                            if (c == 123) {
                                GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                                templateSection.append("escHtml{->");
                                GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                                templateSection.append("}}");
                                writingString = true;
                                continue;
                            }
                        } else if (c == 120) {
                            c = templateCode.read();
                            if (bc == 92) {
                                GroovyTemplateCompiler.appendCharacter('x', templateSection, writingString);
                            }
                            if (c == 123) {
                                GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                                templateSection.append("escXml{->");
                                GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                                templateSection.append("}}");
                                writingString = true;
                                continue;
                            }
                        } else if (c == 106) {
                            c = templateCode.read();
                            if (bc == 92) {
                                GroovyTemplateCompiler.appendCharacter('j', templateSection, writingString);
                            }
                            if (c == 123) {
                                GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                                templateSection.append("escJs{->");
                                GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                                templateSection.append("}}");
                                writingString = true;
                                continue;
                            }
                        } else if (c == 115) {
                            c = templateCode.read();
                            if (bc == 92) {
                                GroovyTemplateCompiler.appendCharacter('s', templateSection, writingString);
                            }
                            if (c == 123) {
                                GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                                templateSection.append("escEql{->");
                                GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                                templateSection.append("}}");
                                writingString = true;
                                continue;
                            }
                            if (c == 108) {
                                c = templateCode.read();
                                if (bc == 92) {
                                    GroovyTemplateCompiler.appendCharacter('l', templateSection, writingString);
                                }
                                if (c == 123) {
                                    GroovyTemplateCompiler.appendCharacter('{', templateSection, writingString);
                                    templateSection.append("escEqlLike{->");
                                    GroovyTemplateCompiler.parseExpr(templateCode, templateSection);
                                    templateSection.append("}}");
                                    writingString = true;
                                    continue;
                                }
                            }
                        }
                    }
                }
                GroovyTemplateCompiler.appendCharacter((char)c, templateSection, writingString);
                writingString = true;
            }
            templateSection.append("\"\"\"");
        }
        templateSection.append("}.asWritable()}}");
        if (importSection.length() > 0) {
            templateExpressions.append((CharSequence)importSection);
        }
        templateExpressions.append((CharSequence)templateSection);
        return templateExpressions.toString();
    }

    private static void appendCharacter(char c, StringBuilder templateExpressions, boolean writingString) {
        if (!writingString) {
            templateExpressions.append("out << \"\"\"");
        }
        templateExpressions.append(c);
    }

    private static void parseExpr(Reader reader, StringBuilder templateExpressions) throws IOException {
        int depth = 0;
        CurrentContext context = CurrentContext.CODE;
        int bc = -1;
        int c = -1;
        boolean esc = false;
        while (true) {
            block22: {
                block21: {
                    bc = c;
                    c = reader.read();
                    if (c == -1 || c == 125 && depth == 0 && context == CurrentContext.CODE) break;
                    if (context != CurrentContext.CODE) break block21;
                    switch (c) {
                        case 123: {
                            ++depth;
                            break;
                        }
                        case 125: {
                            --depth;
                            break;
                        }
                        case 34: {
                            context = CurrentContext.STRING_D;
                            break;
                        }
                        case 39: {
                            context = CurrentContext.STRING_S;
                            break;
                        }
                        case 47: {
                            if (bc == 47) {
                                context = CurrentContext.COMMENT_LINE;
                                break;
                            }
                            break block22;
                        }
                        case 42: {
                            if (bc == 47) {
                                context = CurrentContext.COMMENT_BLOCK;
                                break;
                            }
                            break block22;
                        }
                    }
                    break block22;
                }
                switch (context.ordinal()) {
                    case 4: {
                        if (c != 47 || bc != 42) break;
                        context = CurrentContext.CODE;
                        break;
                    }
                    case 3: {
                        if (c != 10) break;
                        context = CurrentContext.CODE;
                        break;
                    }
                    case 1: {
                        if (c == 92 && !esc) {
                            esc = true;
                            break;
                        }
                        if (c == 34 && !esc) {
                            context = CurrentContext.CODE;
                        }
                        esc = false;
                        break;
                    }
                    case 2: {
                        if (c == 92 && !esc) {
                            esc = true;
                            break;
                        }
                        if (c == 39 && !esc) {
                            context = CurrentContext.CODE;
                        }
                        esc = false;
                        break;
                    }
                }
            }
            templateExpressions.append((char)c);
        }
    }

    private static void parseImport(Reader reader, StringBuilder importSection) throws IOException {
        int c;
        boolean consumePageToken = false;
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                importSection.append('%');
            } else if (!consumePageToken && c == 112) {
                c = reader.read();
                if (c == 97) {
                    c = reader.read();
                    if (c == 103) {
                        c = reader.read();
                        if (c == 101) {
                            c = reader.read();
                            if (GroovyTemplateCompiler.isSpace(c)) {
                                consumePageToken = true;
                                GroovyTemplateCompiler.parsePageImportDirective(reader, importSection);
                                return;
                            }
                            importSection.append("page");
                        } else {
                            importSection.append("pag");
                        }
                    } else {
                        importSection.append("pa");
                    }
                } else {
                    importSection.append('p');
                }
            }
            importSection.append((char)c);
            if (GroovyTemplateCompiler.isSpace(c)) continue;
            consumePageToken = true;
        }
        importSection.append(";\n");
    }

    private static void parsePageImportDirective(Reader reader, StringBuilder importSection) throws IOException {
        int c;
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                importSection.append('%');
            }
            if (GroovyTemplateCompiler.isSpace(c) || c != 105 || reader.read() != 109 || reader.read() != 112 || reader.read() != 111 || reader.read() != 114 || reader.read() != 116) continue;
            int cc = reader.read();
            while (GroovyTemplateCompiler.isSpace(cc)) {
                cc = reader.read();
            }
            if (cc != 61) continue;
            cc = reader.read();
            while (GroovyTemplateCompiler.isSpace(cc)) {
                cc = reader.read();
            }
            if (cc != 34 && cc != 39) continue;
            GroovyTemplateCompiler.parseImportAttribute(reader, importSection, cc);
        }
    }

    private static void parseImportAttribute(Reader reader, StringBuilder importSection, int terminate) throws IOException {
        int c;
        boolean insertImport = true;
        boolean isappending = false;
        while ((c = reader.read()) != -1 && c != terminate) {
            if (c == 44) {
                insertImport = true;
                continue;
            }
            if (insertImport) {
                if (isappending) {
                    importSection.append(";\n");
                    isappending = false;
                }
                importSection.append("import ");
                insertImport = false;
            }
            if (GroovyTemplateCompiler.isSpace(c)) continue;
            importSection.append((char)c);
            isappending = true;
        }
        if (isappending) {
            importSection.append(";\n");
        }
    }

    private static void parseSection(int pendingC, Reader reader, boolean writingString, StringBuilder templateExpressions) throws IOException {
        int c;
        if (writingString) {
            templateExpressions.append("\"\"\";\n");
        }
        templateExpressions.append((char)pendingC);
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                templateExpressions.append('%');
            }
            templateExpressions.append((char)c);
        }
        templateExpressions.append("\n ");
    }

    private static void parseExpression(Reader reader, boolean writingString, StringBuilder templateExpressions) throws IOException {
        int c;
        if (!writingString) {
            templateExpressions.append("out << \"\"\"");
        }
        templateExpressions.append("${");
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                templateExpressions.append('%');
            }
            templateExpressions.append((char)c);
        }
        templateExpressions.append('}');
    }

    static enum CurrentContext {
        CODE,
        STRING_D,
        STRING_S,
        COMMENT_LINE,
        COMMENT_BLOCK;

    }
}

