/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.session;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.spi.Service;

public abstract class SessionService
implements Service {
    private static final String SESSION_NAME = "mtp.session.store.Session";
    private static final String SESSION_STATELESS_FLAG = "mtp.session.store.StatelessFlag";

    public Session getSession(boolean create) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        Session s = (Session)ec.getAttribute(SESSION_NAME);
        if (s == null) {
            StatelessFlag f = (StatelessFlag)((Object)ec.getAttribute(SESSION_STATELESS_FLAG));
            if (f == null) {
                s = this.getSessionInternal(create);
            } else if (f == StatelessFlag.ENABLE) {
                s = this.getSessionInternal(false);
                if (s == null && create) {
                    s = new OnetimeSessionImpl(this);
                }
            } else if (create) {
                s = new OnetimeSessionImpl(this);
            }
            if (s != null) {
                ec.setAttribute(SESSION_NAME, s, true);
            }
        }
        return s;
    }

    public void setSessionStateless(boolean force) {
        if (force) {
            ExecuteContext ec = ExecuteContext.getCurrentContext();
            ec.setAttribute(SESSION_STATELESS_FLAG, (Object)StatelessFlag.FORCE, true);
            ec.removeAttribute(SESSION_NAME);
        } else {
            ExecuteContext.getCurrentContext().setAttribute(SESSION_STATELESS_FLAG, (Object)StatelessFlag.ENABLE, true);
        }
    }

    public boolean isSessionStateless() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        return ec.getAttribute(SESSION_STATELESS_FLAG) != null;
    }

    public void removeSessionFromExecuteContext(Session session) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        Session s = (Session)ec.getAttribute(SESSION_NAME);
        if (s != null && s == session) {
            ec.removeAttribute(SESSION_NAME);
        }
    }

    protected abstract Session getSessionInternal(boolean var1);

    private static enum StatelessFlag {
        ENABLE,
        FORCE;

    }

    public static class OnetimeSessionImpl
    implements Session {
        private static KeyGenerator gen = new KeyGenerator();
        private final ConcurrentHashMap<String, Object> store = new ConcurrentHashMap();
        private volatile String id = "es-" + gen.generateId();
        private final SessionService service;
        private final long createDate = System.currentTimeMillis();

        public OnetimeSessionImpl(SessionService service) {
            this.service = service;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object getAttribute(String name) {
            return this.store.get(name);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.store.put(name, value);
        }

        @Override
        public void removeAttribute(String name) {
            this.store.remove(name);
        }

        @Override
        public Iterator<String> getAttributeNames() {
            return ((ConcurrentHashMap.KeySetView)this.store.keySet()).iterator();
        }

        @Override
        public void invalidate() {
            this.store.clear();
            this.service.removeSessionFromExecuteContext(this);
        }

        @Override
        public Object getSessionMutexObject() {
            return this;
        }

        @Override
        public long getCreationTime() {
            return this.createDate;
        }

        @Override
        public void changeSessionId() {
            this.id = "es-" + gen.generateId();
        }
    }
}

