/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class MetaTenant
extends BaseRootMetaData
implements DefinableMetaData<Tenant> {
    private static final long serialVersionUID = -891000660283577842L;
    private static Logger logger = LoggerFactory.getLogger(MetaTenant.class);
    private List<MetaTenantConfig> tenantConfigs;

    public MetaTenant() {
    }

    public MetaTenant(Tenant tenant) {
        this.applyConfig(tenant);
    }

    @Override
    public MetaTenant copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public MetaTenantHandler createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaTenantHandler();
    }

    public List<MetaTenantConfig> getTenantConfigs() {
        return this.tenantConfigs;
    }

    public void setTenantConfigs(List<MetaTenantConfig> tenantConfigs) {
        this.tenantConfigs = tenantConfigs;
    }

    public void applyToTenant(Tenant tenant) {
        tenant.setDescription(this.getDescription());
        tenant.setDisplayName(this.getDisplayName());
        tenant.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
        if (this.tenantConfigs != null) {
            tenant.setTenantConfigs(this.tenantConfigs.stream().map(config -> config.currentConfig()).filter(config -> config != null).collect(Collectors.toList()));
        } else {
            tenant.setTenantConfigs(null);
        }
    }

    @Override
    public void applyConfig(Tenant definition) {
        this.setName(definition.getName());
        this.setDescription(definition.getDescription());
        this.setDisplayName(definition.getDisplayName());
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
        if (definition.getTenantConfigs() != null) {
            MetaTenantService mts = ServiceRegistry.getRegistry().getService(MetaTenantService.class);
            this.tenantConfigs = definition.getTenantConfigs().stream().map(defConfig -> {
                MetaTenantConfig metaConfig = mts.toMetaConfig((TenantConfig)defConfig);
                if (metaConfig != null) {
                    metaConfig.applyConfig(defConfig);
                }
                return metaConfig;
            }).filter(metaConfig -> metaConfig != null).sorted((config1, config2) -> config1.getClass().getName().compareTo(config2.getClass().getName())).collect(Collectors.toList());
        } else {
            this.tenantConfigs = null;
        }
    }

    @Override
    public Tenant currentConfig() {
        Tenant definition = new Tenant();
        this.applyToTenant(definition);
        return definition;
    }

    public class MetaTenantHandler
    extends BaseMetaDataRuntime {
        private Map<String, MetaTenantConfig.MetaTenantConfigRuntime> tenantConfigsRuntimes;

        public MetaTenantHandler() {
            if (MetaTenant.this.tenantConfigs == null) {
                MetaTenant.this.tenantConfigs = new ArrayList<MetaTenantConfig>();
            }
            MetaTenantService mts = ServiceRegistry.getRegistry().getService(MetaTenantService.class);
            for (Class<? extends MetaTenantConfig> cz : mts.getMetaTenantConfigClasses()) {
                if (this.hasMetaTenantConfig(cz, MetaTenant.this.tenantConfigs)) continue;
                try {
                    MetaTenantConfig mtc = cz.newInstance();
                    MetaTenant.this.tenantConfigs.add(mtc);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.warn("Can not instantiate " + cz.getName());
                }
            }
            this.tenantConfigsRuntimes = new HashMap<String, MetaTenantConfig.MetaTenantConfigRuntime>();
            for (MetaTenantConfig config : MetaTenant.this.tenantConfigs) {
                MetaTenantConfig.MetaTenantConfigRuntime runtime = config.createRuntime(this);
                if (runtime == null) continue;
                this.tenantConfigsRuntimes.put(runtime.getClass().getName(), runtime);
            }
        }

        private boolean hasMetaTenantConfig(Class<? extends MetaTenantConfig> cz, List<MetaTenantConfig> list) {
            for (MetaTenantConfig mtc : list) {
                if (mtc == null || !mtc.getClass().equals(cz)) continue;
                return true;
            }
            return false;
        }

        public <R extends MetaTenantConfig.MetaTenantConfigRuntime> R getConfigRuntime(Class<R> tenantConfigClass) {
            return (R)this.tenantConfigsRuntimes.get(tenantConfigClass.getName());
        }

        @Override
        public MetaTenant getMetaData() {
            return MetaTenant.this;
        }

        public void applyMetaDataToTenant(Tenant tenant) {
            MetaTenant.this.applyToTenant(tenant);
            this.tenantConfigsRuntimes.values().forEach(runtime -> runtime.applyMetaDataToTenant(tenant));
        }
    }
}

