/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantAuthInfo;

public class MetaTenantAuthInfo
extends MetaTenantConfig<TenantAuthInfo> {
    private static final long serialVersionUID = -1957829955963005918L;
    private boolean useRememberMe;
    private List<String> userAdminRoles;

    public List<String> getUserAdminRoles() {
        return this.userAdminRoles;
    }

    public void setUserAdminRoles(List<String> userAdminRoles) {
        this.userAdminRoles = userAdminRoles;
    }

    public boolean isUseRememberMe() {
        return this.useRememberMe;
    }

    public void setUseRememberMe(boolean useRememberMe) {
        this.useRememberMe = useRememberMe;
    }

    @Override
    public MetaData copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(TenantAuthInfo definition) {
        this.setUseRememberMe(definition.isUseRememberMe());
        if (definition.getUserAdminRoles() != null) {
            this.setUserAdminRoles(new ArrayList<String>(definition.getUserAdminRoles()));
        } else {
            this.setUserAdminRoles(null);
        }
    }

    @Override
    public TenantAuthInfo currentConfig() {
        TenantAuthInfo definition = new TenantAuthInfo();
        definition.setUseRememberMe(this.isUseRememberMe());
        if (this.userAdminRoles != null) {
            definition.setUserAdminRoles(new ArrayList<String>(this.userAdminRoles));
        }
        return definition;
    }

    @Override
    public MetaTenantAuthInfoRuntime createRuntime(MetaTenant.MetaTenantHandler tenantRuntime) {
        return new MetaTenantAuthInfoRuntime();
    }

    public class MetaTenantAuthInfoRuntime
    extends MetaTenantConfig.MetaTenantConfigRuntime {
        public MetaTenantAuthInfoRuntime() {
            super(MetaTenantAuthInfo.this);
        }

        @Override
        public MetaData getMetaData() {
            return MetaTenantAuthInfo.this;
        }

        @Override
        public void applyMetaDataToTenant(Tenant tenant) {
        }
    }
}

