/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.tenant.TenantStore;
import org.iplass.mtp.impl.tenant.rdb.RdbTenantStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;

public class TenantService
implements Service {
    private TenantStore store;

    @Override
    public void init(Config config) {
        this.store = config.getValueWithSupplier("store", TenantStore.class, () -> new RdbTenantStore());
    }

    @Override
    public void destroy() {
    }

    public Tenant getTenant(String url) {
        return this.store.getTenant(url);
    }

    public Tenant getTenant(int id) {
        return this.store.getTenant(id);
    }

    public void registTenant(Tenant tenant, String registId) {
        this.store.registTenant(tenant, registId);
    }

    public void updateTenant(Tenant tenant) {
        this.updateTenant(tenant, ExecuteContext.getCurrentContext().getClientId());
    }

    public void updateTenant(Tenant tenant, String updateId) {
        this.updateTenant(tenant, updateId, false);
    }

    public void updateTenant(Tenant tenant, String updateId, boolean forceUpdate) {
        this.store.updateTenant(tenant, updateId, forceUpdate);
    }

    public List<Integer> getAllTenantIdList() {
        return this.store.getAllTenantIdList();
    }
}

