/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.time.DateUtils;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;

public class ConvertUtil {
    private static ConvertUtilsBean cub = new ConvertUtilsBean();

    public static <T> T convert(Class<T> type, Object from) {
        if (from == null) {
            return null;
        }
        if (type.isInstance(from)) {
            return (T)from;
        }
        if (from instanceof String) {
            return ConvertUtil.convertFromString(type, (String)from);
        }
        if (from instanceof SelectValue) {
            from = ((SelectValue)from).getValue();
        }
        if (from instanceof byte[] && type == String.class) {
            return (T)ConvertUtil.convertToString((byte[])from);
        }
        return (T)cub.convert(from, type);
    }

    private static String convertToString(byte[] data) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (byte b : data) {
            i = b & 0xFF;
            if (i <= 15) {
                str.append('0');
            }
            str.append(Integer.toHexString(i));
        }
        return str.toString();
    }

    public static String formatDate(java.util.Date date, String pattern, boolean useTenantTimeZone) {
        SimpleDateFormat fdf = DateUtil.getSimpleDateFormat(pattern, useTenantTimeZone);
        return fdf.format(date);
    }

    public static <T extends java.util.Date> T convertToDate(Class<T> type, Object from, String pattern, boolean useTenantTimeZone) {
        if (from == null) {
            return null;
        }
        if (type == from.getClass()) {
            return (T)((java.util.Date)from);
        }
        java.util.Date date = null;
        if (from instanceof java.util.Date) {
            date = (java.util.Date)from;
        } else if (from instanceof String) {
            if (StringUtil.isBlank((String)from)) {
                return null;
            }
            try {
                SimpleDateFormat sdf = DateUtil.getSimpleDateFormat(pattern, useTenantTimeZone);
                sdf.setLenient(false);
                date = sdf.parse((String)from);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("not support type:" + String.valueOf(from));
        }
        if (type == Date.class) {
            return (T)new Date(date.getTime());
        }
        if (type == Timestamp.class) {
            return (T)new Timestamp(date.getTime());
        }
        if (type == Time.class) {
            return (T)Time.valueOf(new Time(date.getTime()).toString());
        }
        throw new IllegalArgumentException("not support type:" + String.valueOf(type));
    }

    public static String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value).toPlainString();
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue()).toPlainString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof SelectValue) {
            return ((SelectValue)value).getValue();
        }
        if (value instanceof BinaryReference) {
            return String.valueOf(((BinaryReference)value).getLobId());
        }
        if (value instanceof Date) {
            SimpleDateFormat format = DateUtil.getSimpleDateFormat("yyyy-MM-dd", false);
            return format.format(value);
        }
        if (value instanceof Time) {
            return ((Time)value).toString();
        }
        if (value instanceof Timestamp) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            return format.format(value);
        }
        if (value instanceof java.util.Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            return format.format(value);
        }
        if (value instanceof byte[]) {
            return ConvertUtil.convertToString((byte[])value);
        }
        return (String)cub.convert(value, String.class);
    }

    public static <T> T convertFromString(Class<T> type, String from) {
        if (StringUtil.isBlank(from)) {
            return null;
        }
        if (type == String.class) {
            return (T)from;
        }
        if (type == Long.class) {
            return (T)Long.valueOf(from);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(from);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(from);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(from);
        }
        if (type == SelectValue.class) {
            return (T)new SelectValue(from);
        }
        if (type == Date.class) {
            try {
                return (T)new Date(DateUtil.getDateInstance(2, false).parse(from).getTime());
            }
            catch (ParseException parseException) {
                try {
                    SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd", false);
                    sdf.setLenient(false);
                    return (T)new Date(sdf.parse(from).getTime());
                }
                catch (ParseException sdf) {
                    try {
                        SimpleDateFormat sdf2 = DateUtil.getSimpleDateFormat("yyyyMMdd", false);
                        sdf2.setLenient(false);
                        return (T)new Date(sdf2.parse(from).getTime());
                    }
                    catch (ParseException sdf2) {
                        try {
                            SimpleDateFormat sdf3 = DateUtil.getSimpleDateFormat(ConvertUtil.getLocaleFormat().getOutputDateFormat(), false);
                            sdf3.setLenient(false);
                            return (T)new Date(sdf3.parse(from).getTime());
                        }
                        catch (ParseException sdf3) {
                            try {
                                SimpleDateFormat sdf4 = DateUtil.getSimpleDateFormat("yyyy/M/d", false);
                                sdf4.setLenient(false);
                                return (T)new Date(sdf4.parse(from).getTime());
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException("Date Format must Locale specific DateFormat.MEDIUM or yyyy-MM-dd or yyyyMMdd.", e);
                            }
                        }
                    }
                }
            }
        }
        if (type == Timestamp.class) {
            try {
                return (T)new Timestamp(DateUtil.getDateTimeInstance(2, 2, true).parse(from).getTime());
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", false);
                    sdf.setLenient(false);
                    return (T)new Timestamp(sdf.parse(from).getTime());
                }
                catch (ParseException sdf) {
                    try {
                        SimpleDateFormat sdf5 = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX", false);
                        sdf5.setLenient(false);
                        return (T)new Timestamp(sdf5.parse(from).getTime());
                    }
                    catch (ParseException sdf5) {
                        try {
                            SimpleDateFormat sdf6 = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", true);
                            sdf6.setLenient(false);
                            return (T)new Timestamp(sdf6.parse(from).getTime());
                        }
                        catch (ParseException sdf6) {
                            try {
                                SimpleDateFormat sdf7 = DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss", true);
                                sdf7.setLenient(false);
                                return (T)new Timestamp(sdf7.parse(from).getTime());
                            }
                            catch (ParseException sdf7) {
                                try {
                                    SimpleDateFormat sdf8 = DateUtil.getSimpleDateFormat("yyyyMMddHHmmssSSS", true);
                                    sdf8.setLenient(false);
                                    return (T)new Timestamp(sdf8.parse(from).getTime());
                                }
                                catch (ParseException sdf8) {
                                    try {
                                        SimpleDateFormat sdf9 = DateUtil.getSimpleDateFormat("yyyyMMddHHmmss", true);
                                        sdf9.setLenient(false);
                                        return (T)new Timestamp(sdf9.parse(from).getTime());
                                    }
                                    catch (ParseException sdf9) {
                                        try {
                                            SimpleDateFormat sdf10 = DateUtil.getSimpleDateFormat(ConvertUtil.getLocaleFormat().getOutputDatetimeSecFormat(), true);
                                            sdf10.setLenient(false);
                                            return (T)new Timestamp(sdf10.parse(from).getTime());
                                        }
                                        catch (ParseException sdf10) {
                                            try {
                                                SimpleDateFormat sdf11 = DateUtil.getSimpleDateFormat("yyyy/M/d H:mm", true);
                                                sdf11.setLenient(false);
                                                return (T)new Timestamp(sdf11.parse(from).getTime());
                                            }
                                            catch (ParseException e2) {
                                                try {
                                                    java.util.Date date = ConvertUtil.convertFromString(Date.class, from);
                                                    date = DateUtils.truncate((java.util.Date)date, (int)5);
                                                    Timestamp ts = ConvertUtil.convertToDate(Timestamp.class, date, null, true);
                                                    return (T)ts;
                                                }
                                                catch (IllegalArgumentException ie) {
                                                    throw new IllegalArgumentException("Timestamp Format must Locale specific DateFormat.MEDIUM or yyyy-MM-dd HH:mm:ss.SSS or yyyy-MM-dd HH:mm:ss or yyyyMMddHHmmssSSS or yyyyMMddHHmmss.", e2);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (type == Time.class) {
            try {
                return (T)new Time(DateUtil.getTimeInstance(2, false).parse(from).getTime());
            }
            catch (ParseException e2) {
                try {
                    SimpleDateFormat sdf = DateUtil.getSimpleDateFormat("HH:mm:ss.SSS", false);
                    sdf.setLenient(false);
                    return (T)new Time(sdf.parse(from).getTime());
                }
                catch (ParseException sdf) {
                    try {
                        SimpleDateFormat sdf12 = DateUtil.getSimpleDateFormat("HH:mm:ss", false);
                        sdf12.setLenient(false);
                        return (T)new Time(sdf12.parse(from).getTime());
                    }
                    catch (ParseException sdf12) {
                        try {
                            SimpleDateFormat sdf13 = DateUtil.getSimpleDateFormat("HHmmssSSS", false);
                            sdf13.setLenient(false);
                            return (T)new Time(sdf13.parse(from).getTime());
                        }
                        catch (ParseException sdf13) {
                            try {
                                SimpleDateFormat sdf14 = DateUtil.getSimpleDateFormat("HHmmss", false);
                                sdf14.setLenient(false);
                                return (T)new Time(sdf14.parse(from).getTime());
                            }
                            catch (ParseException sdf14) {
                                try {
                                    SimpleDateFormat sdf15 = DateUtil.getSimpleDateFormat(ConvertUtil.getLocaleFormat().getOutputTimeSecFormat(), false);
                                    sdf15.setLenient(false);
                                    return (T)new Time(sdf15.parse(from).getTime());
                                }
                                catch (ParseException sdf15) {
                                    try {
                                        SimpleDateFormat sdf16 = DateUtil.getSimpleDateFormat("H:mm:ss", false);
                                        sdf16.setLenient(false);
                                        return (T)new Time(sdf16.parse(from).getTime());
                                    }
                                    catch (ParseException e) {
                                        throw new IllegalArgumentException("Time Format must Locale specific DateFormat.MEDIUM or HH:mm:ss.SSS or HH:mm:ss or HHmmssSSS or HHmmss.", e);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (type == BigDecimal.class) {
            return (T)new BigDecimal(from);
        }
        throw new IllegalArgumentException("can not convert String to " + String.valueOf(type));
    }

    private static LocaleFormat getLocaleFormat() {
        return ExecuteContext.getCurrentContext().getLocaleFormat();
    }
}

