/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.impl.util.HashUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformUtil {
    private static final Logger logger;
    public static final String TITLE_KEY = "Implementation-Title";
    public static final String VERSION_KEY = "Implementation-Version";
    public static final String VENDOR_KEY = "Implementation-Vendor";
    public static final String BUILD_KEY = "Build-Date";
    private static final PlatformInfo platformInfo;

    public static String getAPIVersion() {
        if (PlatformUtil.platformInfo.isError || platformInfo.getVersionHash() == null) {
            return "devMode_" + System.currentTimeMillis();
        }
        return platformInfo.getVersionHash();
    }

    public static PlatformInfo getPlatformInformation() {
        return platformInfo;
    }

    private static void addInfo(String key, Attributes attributes) {
        PlatformUtil.addInfo(key, attributes, "not defined");
    }

    private static void addInfo(String key, Attributes attributes, String nullValue) {
        if (attributes.getValue(key) != null) {
            platformInfo.addInfomation(key, attributes.getValue(key));
        } else {
            platformInfo.addInfomation(key, nullValue);
        }
    }

    static {
        block9: {
            logger = LoggerFactory.getLogger(PlatformUtil.class);
            platformInfo = new PlatformInfo();
            URLConnection conn = null;
            try {
                ClassLoader classLoader = Definition.class.getClassLoader();
                URL classURL = classLoader.getResource(Definition.class.getName().replace(".", "/") + ".class");
                conn = classURL.openConnection();
                if (conn == null) {
                    logger.debug("platform information source is null.");
                    platformInfo.setError(true);
                    platformInfo.setErrorMessage("platform information source is null.");
                    break block9;
                }
                logger.debug("platform information source is " + conn.getClass().getName());
                if (conn instanceof JarURLConnection) {
                    JarURLConnection jarConn = (JarURLConnection)conn;
                    Manifest manifest = jarConn.getManifest();
                    if (manifest == null || manifest.getMainAttributes().isEmpty()) {
                        logger.debug("platform information is empty.");
                        platformInfo.setError(true);
                        platformInfo.setErrorMessage("platform information is empty.");
                        break block9;
                    }
                    Attributes attributes = manifest.getMainAttributes();
                    PlatformUtil.addInfo(TITLE_KEY, attributes);
                    PlatformUtil.addInfo(VERSION_KEY, attributes, null);
                    PlatformUtil.addInfo(VENDOR_KEY, attributes);
                    PlatformUtil.addInfo(BUILD_KEY, attributes);
                    String version = platformInfo.getVersion();
                    if (version != null) {
                        String cashKey = platformInfo.getTitle() + "_" + version;
                        try {
                            platformInfo.setVersionHash(HashUtil.digest(cashKey, "SHA-256"));
                        }
                        catch (NoSuchAlgorithmException e) {
                            platformInfo.setVersionHash(cashKey);
                        }
                        logger.info("platform version is " + cashKey + ". version hash=" + platformInfo.getVersionHash());
                        break block9;
                    }
                    platformInfo.setError(true);
                    platformInfo.setErrorMessage("platform version information read failed.");
                    break block9;
                }
                logger.debug("platform information source is direct or not support type. type=" + conn.getClass().getName());
                platformInfo.setError(true);
                platformInfo.setErrorMessage("platform information source is direct or not support type. type=" + conn.getClass().getName());
            }
            catch (IOException e) {
                logger.debug("get platform information failed.", (Throwable)e);
                platformInfo.setError(true);
                platformInfo.setErrorMessage("platform information read failed.");
            }
        }
        if (PlatformUtil.platformInfo.isError) {
            logger.warn(PlatformUtil.platformInfo.errorMessage);
        }
    }

    public static class PlatformInfo
    implements Serializable {
        private static final long serialVersionUID = 8594045462747319422L;
        private boolean isError = false;
        private String errorMessage = null;
        private Map<String, String> infomations;
        private String versionHash;

        public boolean isError() {
            return this.isError;
        }

        public void setError(boolean isError) {
            this.isError = isError;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Map<String, String> getInfomations() {
            return this.infomations;
        }

        public void setInfomations(Map<String, String> infomations) {
            this.infomations = infomations;
        }

        public void addInfomation(String key, String value) {
            if (this.infomations == null) {
                this.infomations = new LinkedHashMap<String, String>();
            }
            this.infomations.put(key, value);
        }

        public String getVersionHash() {
            return this.versionHash;
        }

        public void setVersionHash(String versionHash) {
            this.versionHash = versionHash;
        }

        public String getVersion() {
            if (this.infomations != null) {
                return this.infomations.get(PlatformUtil.VERSION_KEY);
            }
            return null;
        }

        public String getTitle() {
            if (this.infomations != null) {
                return this.infomations.get(PlatformUtil.TITLE_KEY);
            }
            return "";
        }
    }
}

