/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.regex.Pattern;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.BinarySizeValidation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationBinarySize
extends MetaValidation {
    private static final long serialVersionUID = 1334805081077727638L;
    private static final Pattern maxPattern = Pattern.compile("${max}", 16);
    private static final Pattern minPattern = Pattern.compile("${min}", 16);
    private Long max;
    private Long min;

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMin() {
        return this.min;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    @Override
    public MetaValidationBinarySize copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandler(this){

            @Override
            public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
                String msg = super.generateErrorMessage(value, context, propertyDisplayName, entityDisplayName);
                if (msg != null) {
                    if (msg.contains("${max}")) {
                        msg = maxPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationBinarySize.this.max));
                    }
                    if (msg.contains("${min}")) {
                        msg = minPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationBinarySize.this.min));
                    }
                }
                return msg;
            }

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                if (value instanceof BinaryReference) {
                    BinaryReference checkVal = (BinaryReference)value;
                    if (MetaValidationBinarySize.this.min != null && checkVal.getSize() < MetaValidationBinarySize.this.min) {
                        return false;
                    }
                    return MetaValidationBinarySize.this.max == null || checkVal.getSize() <= MetaValidationBinarySize.this.max;
                }
                throw new EntityRuntimeException("not support type:" + String.valueOf(value.getClass()));
            }
        };
    }

    @Override
    public BinarySizeValidation currentConfig(EntityContext context) {
        BinarySizeValidation def = new BinarySizeValidation();
        this.fillTo(def);
        def.setMax(this.max);
        def.setMin(this.min);
        return def;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        BinarySizeValidation def = (BinarySizeValidation)definition;
        this.max = def.getMax();
        this.min = def.getMin();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationBinarySize other = (MetaValidationBinarySize)obj;
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return !(this.min == null ? other.min != null : !this.min.equals(other.min));
    }
}

