/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.Iterator;
import org.iplass.mtp.entity.PropertyValidator;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.JavaClassValidation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationJavaClass
extends MetaValidation {
    private static final long serialVersionUID = 6400430254617918235L;
    private String className;
    private boolean asArray = false;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isAsArray() {
        return this.asArray;
    }

    public void setAsArray(boolean asArray) {
        this.asArray = asArray;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        JavaClassValidation def = (JavaClassValidation)definition;
        this.className = def.getClassName();
        this.asArray = def.isAsArray();
    }

    @Override
    public MetaValidationJavaClass copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandlerJavaClass(entity, property);
    }

    @Override
    public JavaClassValidation currentConfig(EntityContext context) {
        JavaClassValidation def = new JavaClassValidation();
        this.fillTo(def);
        def.setClassName(this.className);
        def.setAsArray(this.asArray);
        return def;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.asArray ? 1231 : 1237);
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationJavaClass other = (MetaValidationJavaClass)obj;
        if (this.asArray != other.asArray) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    private class ValidationHandlerJavaClass
    extends ValidationHandler {
        private PropertyValidator validator;

        ValidationHandlerJavaClass(MetaEntity entity, MetaProperty property) {
            super(MetaValidationJavaClass.this);
            try {
                this.validator = (PropertyValidator)Class.forName(MetaValidationJavaClass.this.className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("can not instantiate " + MetaValidationJavaClass.this.className, e);
            }
        }

        @Override
        public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
            String msg = super.generateErrorMessage(value, context, propertyDisplayName, entityDisplayName);
            Iterator<String> it = context.getAttributeNames();
            while (it.hasNext()) {
                String key = it.next();
                String target = "${" + key + "}";
                msg = msg.replace(target, String.valueOf(context.getAttribute(key)));
            }
            return msg;
        }

        @Override
        public boolean validate(Object value, ValidationContext context) {
            return this.validator.validate(value, context);
        }

        @Override
        public boolean validateArray(Object[] values, ValidationContext context) {
            if (MetaValidationJavaClass.this.asArray) {
                return this.validate(values, context);
            }
            return super.validateArray(values, context);
        }
    }
}

