/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.LengthValidation;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;
import org.iplass.mtp.spi.ServiceRegistry;

public class MetaValidationLength
extends MetaValidation {
    private static final long serialVersionUID = -8535627564419203213L;
    private static final Pattern maxPattern = Pattern.compile("${max}", 16);
    private static final Pattern minPattern = Pattern.compile("${min}", 16);
    private Integer max;
    private Integer min;
    private boolean checkBytes;
    private boolean surrogatePairAsOneChar;

    public boolean isSurrogatePairAsOneChar() {
        return this.surrogatePairAsOneChar;
    }

    public void setSurrogatePairAsOneChar(boolean surrogatePairAsOneChar) {
        this.surrogatePairAsOneChar = surrogatePairAsOneChar;
    }

    public boolean isCheckBytes() {
        return this.checkBytes;
    }

    public void setCheckBytes(boolean checkBytes) {
        this.checkBytes = checkBytes;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    @Override
    public MetaValidationLength copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        final String charset = ServiceRegistry.getRegistry().getService(StoreService.class).getCharset();
        return new ValidationHandler(this){

            @Override
            public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
                String msg = super.generateErrorMessage(value, context, propertyDisplayName, entityDisplayName);
                if (msg != null) {
                    if (msg.contains("${max}")) {
                        msg = maxPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationLength.this.max));
                    }
                    if (msg.contains("${min}")) {
                        msg = minPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationLength.this.min));
                    }
                }
                return msg;
            }

            @Override
            public void init() {
            }

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                if (value instanceof String) {
                    block13: {
                        String checkVal = (String)value;
                        if (MetaValidationLength.this.checkBytes) {
                            try {
                                int length = checkVal.getBytes(charset).length;
                                if (MetaValidationLength.this.min != null && length < MetaValidationLength.this.min) {
                                    return false;
                                }
                                if (MetaValidationLength.this.max != null && length > MetaValidationLength.this.max) {
                                    return false;
                                }
                                break block13;
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new EntityRuntimeException(e);
                            }
                        }
                        if (MetaValidationLength.this.surrogatePairAsOneChar) {
                            int codePointCount = checkVal.codePointCount(0, checkVal.length());
                            if (MetaValidationLength.this.min != null && codePointCount < MetaValidationLength.this.min) {
                                return false;
                            }
                            if (MetaValidationLength.this.max != null && codePointCount > MetaValidationLength.this.max) {
                                return false;
                            }
                        } else {
                            if (MetaValidationLength.this.min != null && checkVal.length() < MetaValidationLength.this.min) {
                                return false;
                            }
                            if (MetaValidationLength.this.max != null && checkVal.length() > MetaValidationLength.this.max) {
                                return false;
                            }
                        }
                    }
                    return true;
                }
                throw new EntityRuntimeException("not support type:" + String.valueOf(value.getClass()));
            }
        };
    }

    @Override
    public LengthValidation currentConfig(EntityContext context) {
        LengthValidation def = new LengthValidation();
        this.fillTo(def);
        def.setMax(this.max);
        def.setMin(this.min);
        def.setCheckBytes(this.checkBytes);
        def.setSurrogatePairAsOneChar(this.surrogatePairAsOneChar);
        return def;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        LengthValidation def = (LengthValidation)definition;
        this.max = def.getMax();
        this.min = def.getMin();
        this.checkBytes = def.isCheckBytes();
        this.surrogatePairAsOneChar = def.isSurrogatePairAsOneChar();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.checkBytes ? 1231 : 1237);
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.surrogatePairAsOneChar ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationLength other = (MetaValidationLength)obj;
        if (this.checkBytes != other.checkBytes) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        return this.surrogatePairAsOneChar == other.surrogatePairAsOneChar;
    }
}

