/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.RangeValidation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationRange
extends MetaValidation {
    private static final long serialVersionUID = -4575600888354853812L;
    private static final Pattern maxPattern = Pattern.compile("${max}", 16);
    private static final Pattern minPattern = Pattern.compile("${min}", 16);
    private String max;
    private String min;
    private boolean maxValueExcluded;
    private boolean minValueExcluded;

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public boolean isMaxValueExcluded() {
        return this.maxValueExcluded;
    }

    public void setMaxValueExcluded(boolean maxValueExcluded) {
        this.maxValueExcluded = maxValueExcluded;
    }

    public boolean isMinValueExcluded() {
        return this.minValueExcluded;
    }

    public void setMinValueExcluded(boolean minValueExcluded) {
        this.minValueExcluded = minValueExcluded;
    }

    @Override
    public MetaValidationRange copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandler(this){
            private boolean isMaxSpecify;
            private boolean isMinSpecify;
            private long maxLong;
            private long minLong;
            private double maxDouble;
            private double minDouble;
            private BigDecimal maxBigDecimal;
            private BigDecimal minBigDecimal;

            @Override
            public void init() {
                if (MetaValidationRange.this.max != null && MetaValidationRange.this.max.length() != 0) {
                    this.isMaxSpecify = true;
                    if (!MetaValidationRange.this.max.contains(".")) {
                        this.maxLong = Long.parseLong(MetaValidationRange.this.max);
                    }
                    this.maxDouble = Double.parseDouble(MetaValidationRange.this.max);
                    this.maxBigDecimal = new BigDecimal(MetaValidationRange.this.max);
                }
                if (MetaValidationRange.this.min != null && MetaValidationRange.this.min.length() != 0) {
                    this.isMinSpecify = true;
                    if (!MetaValidationRange.this.min.contains(".")) {
                        this.minLong = Long.parseLong(MetaValidationRange.this.min);
                    }
                    this.minDouble = Double.parseDouble(MetaValidationRange.this.min);
                    this.minBigDecimal = new BigDecimal(MetaValidationRange.this.min);
                }
            }

            @Override
            public String generateErrorMessage(Object value, ValidationContext context, String propertyDisplayName, String entityDisplayName) {
                String msg = super.generateErrorMessage(value, context, propertyDisplayName, entityDisplayName);
                if (msg != null) {
                    if (msg.contains("${max}")) {
                        msg = maxPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationRange.this.max));
                    }
                    if (msg.contains("${min}")) {
                        msg = minPattern.matcher(msg).replaceAll(String.valueOf(MetaValidationRange.this.min));
                    }
                }
                return msg;
            }

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                if (value instanceof Long) {
                    return this.checkLong((Long)value);
                }
                if (value instanceof Double) {
                    return this.checkDouble((Double)value);
                }
                if (value instanceof BigDecimal) {
                    return this.checkBigDecimal((BigDecimal)value);
                }
                throw new EntityRuntimeException("not support type:" + String.valueOf(value.getClass()));
            }

            private boolean checkDouble(Double value) {
                double dVal = value;
                if (this.isMaxSpecify && (MetaValidationRange.this.maxValueExcluded ? dVal >= this.maxDouble : dVal > this.maxDouble)) {
                    return false;
                }
                return !this.isMinSpecify || !(MetaValidationRange.this.minValueExcluded ? dVal <= this.minDouble : dVal < this.minDouble);
            }

            private boolean checkLong(Long value) {
                long lVal = value;
                if (this.isMaxSpecify && (MetaValidationRange.this.maxValueExcluded ? lVal >= this.maxLong : lVal > this.maxLong)) {
                    return false;
                }
                return !this.isMinSpecify || !(MetaValidationRange.this.minValueExcluded ? lVal <= this.minLong : lVal < this.minLong);
            }

            private boolean checkBigDecimal(BigDecimal value) {
                if (this.isMaxSpecify && (MetaValidationRange.this.maxValueExcluded ? value.compareTo(this.maxBigDecimal) >= 0 : value.compareTo(this.maxBigDecimal) > 0)) {
                    return false;
                }
                return !this.isMinSpecify || !(MetaValidationRange.this.minValueExcluded ? value.compareTo(this.minBigDecimal) <= 0 : value.compareTo(this.minBigDecimal) < 0);
            }
        };
    }

    @Override
    public RangeValidation currentConfig(EntityContext context) {
        RangeValidation def = new RangeValidation();
        this.fillTo(def);
        def.setMax(this.max);
        def.setMin(this.min);
        def.setMaxValueExcluded(this.maxValueExcluded);
        def.setMinValueExcluded(this.minValueExcluded);
        return def;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        RangeValidation def = (RangeValidation)definition;
        this.max = def.getMax();
        this.min = def.getMin();
        this.maxValueExcluded = def.isMaxValueExcluded();
        this.minValueExcluded = def.isMinValueExcluded();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.maxValueExcluded ? 1231 : 1237);
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + (this.minValueExcluded ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationRange other = (MetaValidationRange)obj;
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.maxValueExcluded != other.maxValueExcluded) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        return this.minValueExcluded == other.minValueExcluded;
    }
}

