/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.regex.Pattern;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.RegexValidation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationRegex
extends MetaValidation {
    private static final long serialVersionUID = 8178209126020452120L;
    private String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public MetaValidationRegex copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandler(this){
            private Pattern compiledPattern;

            @Override
            public void init() {
                this.compiledPattern = Pattern.compile(MetaValidationRegex.this.pattern);
            }

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                String checkVal = null;
                if (value instanceof Number) {
                    checkVal = value.toString();
                } else if (value instanceof String) {
                    checkVal = (String)value;
                } else {
                    throw new EntityRuntimeException("not support type:" + String.valueOf(value.getClass()));
                }
                return this.compiledPattern.matcher(checkVal).matches();
            }
        };
    }

    @Override
    public RegexValidation currentConfig(EntityContext context) {
        RegexValidation def = new RegexValidation();
        this.fillTo(def);
        def.setPattern(this.pattern);
        return def;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        RegexValidation def = (RegexValidation)definition;
        this.pattern = def.getPattern();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationRegex other = (MetaValidationRegex)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }
}

