/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import jakarta.validation.Validator;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.BinarySizeValidation;
import org.iplass.mtp.entity.definition.validations.BinaryTypeValidation;
import org.iplass.mtp.entity.definition.validations.ExistsValidation;
import org.iplass.mtp.entity.definition.validations.JavaClassValidation;
import org.iplass.mtp.entity.definition.validations.LengthValidation;
import org.iplass.mtp.entity.definition.validations.NotNullValidation;
import org.iplass.mtp.entity.definition.validations.RangeValidation;
import org.iplass.mtp.entity.definition.validations.RegexValidation;
import org.iplass.mtp.entity.definition.validations.ScriptingValidation;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.MetaValidationBinarySize;
import org.iplass.mtp.impl.validation.MetaValidationBinaryType;
import org.iplass.mtp.impl.validation.MetaValidationExists;
import org.iplass.mtp.impl.validation.MetaValidationJavaClass;
import org.iplass.mtp.impl.validation.MetaValidationLength;
import org.iplass.mtp.impl.validation.MetaValidationNotNull;
import org.iplass.mtp.impl.validation.MetaValidationRange;
import org.iplass.mtp.impl.validation.MetaValidationRegex;
import org.iplass.mtp.impl.validation.MetaValidationScripting;
import org.iplass.mtp.impl.validation.bean.BeanValidationConfig;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class ValidationService
implements Service {
    private BeanValidationConfig beanValidation;
    private Validator validator;

    public Validator getValidator() {
        return this.validator;
    }

    public BeanValidationConfig getBeanValidation() {
        return this.beanValidation;
    }

    public MetaValidation createValidationMetaData(ValidationDefinition def) {
        MetaValidation meta = null;
        if (def instanceof NotNullValidation) {
            meta = new MetaValidationNotNull();
        } else if (def instanceof RangeValidation) {
            meta = new MetaValidationRange();
        } else if (def instanceof RegexValidation) {
            meta = new MetaValidationRegex();
        } else if (def instanceof LengthValidation) {
            meta = new MetaValidationLength();
        } else if (def instanceof ScriptingValidation) {
            meta = new MetaValidationScripting();
        } else if (def instanceof JavaClassValidation) {
            meta = new MetaValidationJavaClass();
        } else if (def instanceof BinarySizeValidation) {
            meta = new MetaValidationBinarySize();
        } else if (def instanceof BinaryTypeValidation) {
            meta = new MetaValidationBinaryType();
        } else if (def instanceof ExistsValidation) {
            meta = new MetaValidationExists();
        }
        if (meta != null) {
            meta.applyConfig(def);
        }
        return meta;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        this.beanValidation = config.getValue("beanValidation", BeanValidationConfig.class);
        if (this.beanValidation != null) {
            this.validator = this.beanValidation.getValidatorFactory().getValidator();
        }
    }
}

