/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.webhook.DefaultWebhookResponseHandler;
import org.iplass.mtp.impl.webhook.WebhookService;
import org.iplass.mtp.impl.webhook.endpoint.MetaWebhookEndpoint;
import org.iplass.mtp.impl.webhook.endpoint.WebhookEndpointService;
import org.iplass.mtp.impl.webhook.template.MetaWebhookTemplate;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webhook.Webhook;
import org.iplass.mtp.webhook.WebhookHeader;
import org.iplass.mtp.webhook.WebhookResponse;
import org.iplass.mtp.webhook.endpoint.WebhookAuthenticationType;
import org.iplass.mtp.webhook.template.definition.WebhookTemplateDefinition;
import org.iplass.mtp.webhook.template.definition.WebhookTemplateDefinitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookServiceImpl
extends AbstractTypedMetaDataService<MetaWebhookTemplate, MetaWebhookTemplate.WebhookTemplateRuntime>
implements WebhookService {
    public static final String WEBHOOK_TEMPLATE_META_PATH = "/webhook/template/";
    private static final String WEBHOOK_ISRETRY = "retry";
    private static final String WEBHOOK_RETRY_MAXIMUMATTEMPTS = "retryMaximumAttempts";
    private static final String WEBHOOK_RETRY_INTERVAL = "retryInterval";
    private static final String WEBHOOK_HMACTOKEN_ALGORITHM = "hmacHashAlgorithm";
    private static final String WEBHOOK_HMACTOKEN_DEFAULTNAME = "hmacTokenDefaultName";
    private static final String WEBHOOK_HTTP_CLIENT_CONFIG = "httpClientConfig";
    private static final String WEBHOOK_DEFAULT_HMACALGORITHM = "HmacSHA256";
    private static final String WEBHOOK_HMAC_TOKEN_DEFAULT_NAME = "X-IPLASS-HMAC";
    private static Logger logger = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private Charset webhookContentCharset = StandardCharsets.UTF_8;
    private AsyncTaskManager atm;
    private WebhookEndpointService wheps;
    private boolean webhookIsRetry;
    private int webhookRetryMaximumAttpempts;
    private int webhookRetryInterval;
    private String webhookHmacHashAlgorithm;
    private String webhookHmacTokenDefaultName;
    private HttpClientConfig webhookHttpClientConfig;
    private CloseableHttpClient webhookHttpClient;

    public static String getFixedPath() {
        return WEBHOOK_TEMPLATE_META_PATH;
    }

    @Override
    public void init(Config config) {
        this.webhookHttpClientConfig = new HttpClientConfig();
        Iterator<String> iterator = config.getNames().iterator();
        while (iterator.hasNext()) {
            String name;
            switch (name = iterator.next()) {
                case "retry": {
                    String tempIsRetry = config.getValue(WEBHOOK_ISRETRY);
                    if ("true".equals(tempIsRetry.replaceAll("\\s", "").toLowerCase())) {
                        this.webhookIsRetry = true;
                        break;
                    }
                    this.webhookIsRetry = false;
                    break;
                }
                case "retryMaximumAttempts": {
                    this.webhookRetryMaximumAttpempts = Integer.valueOf(config.getValue(WEBHOOK_RETRY_MAXIMUMATTEMPTS));
                    break;
                }
                case "retryInterval": {
                    this.webhookRetryInterval = Integer.valueOf(config.getValue(WEBHOOK_RETRY_INTERVAL));
                    break;
                }
                case "hmacHashAlgorithm": {
                    this.webhookHmacHashAlgorithm = config.getValue(WEBHOOK_HMACTOKEN_ALGORITHM);
                    if (this.webhookHmacHashAlgorithm != null && !this.webhookHmacHashAlgorithm.replaceAll("\\s", "").isEmpty()) break;
                    this.webhookHmacHashAlgorithm = WEBHOOK_DEFAULT_HMACALGORITHM;
                    break;
                }
                case "hmacTokenDefaultName": {
                    this.webhookHmacTokenDefaultName = config.getValue(WEBHOOK_HMACTOKEN_DEFAULTNAME);
                    if (this.webhookHmacTokenDefaultName != null && !this.webhookHmacTokenDefaultName.replaceAll("\\s", "").isEmpty()) break;
                    this.webhookHmacTokenDefaultName = WEBHOOK_HMAC_TOKEN_DEFAULT_NAME;
                    break;
                }
                case "httpClientConfig": {
                    this.webhookHttpClientConfig = config.getValue(WEBHOOK_HTTP_CLIENT_CONFIG, HttpClientConfig.class);
                    if (this.webhookHttpClientConfig != null) break;
                    this.webhookHttpClientConfig = new HttpClientConfig();
                }
            }
        }
        this.webhookHttpClientConfig.inited(this, config);
        this.atm = ManagerLocator.getInstance().getManager(AsyncTaskManager.class);
        this.wheps = ServiceRegistry.getRegistry().getService(WebhookEndpointService.class);
        this.initWebhookHttpClient();
    }

    private void initWebhookHttpClient() {
        if (this.webhookHttpClient == null) {
            this.webhookHttpClient = this.webhookHttpClientConfig.getInstance();
        }
    }

    @Override
    public void destroy() {
        try {
            this.webhookHttpClient.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    @Override
    public Class<MetaWebhookTemplate> getMetaDataType() {
        return MetaWebhookTemplate.class;
    }

    @Override
    public Class<MetaWebhookTemplate.WebhookTemplateRuntime> getRuntimeType() {
        return MetaWebhookTemplate.WebhookTemplateRuntime.class;
    }

    @Override
    public Webhook getWebhookByName(String webhookDefinitionName, Map<String, Object> binding) {
        MetaWebhookTemplate.WebhookTemplateRuntime webhookRuntime = (MetaWebhookTemplate.WebhookTemplateRuntime)this.getRuntimeByName(webhookDefinitionName);
        Webhook webhook = webhookRuntime.createWebhook(binding);
        return webhook;
    }

    @Override
    public void sendWebhookSync(Webhook webhook) {
        this.sendWebhook(webhook);
    }

    @Override
    public void sendWebhookAsync(Webhook webhook) {
        this.atm.executeOnThread(new WebhookCallable(webhook));
    }

    @Override
    public Webhook generateWebhook(String webhookDefinitionName, Map<String, Object> binding, String endpointDefinitionName) {
        MetaWebhookTemplate.WebhookTemplateRuntime webhookRuntime = (MetaWebhookTemplate.WebhookTemplateRuntime)this.getRuntimeByName(webhookDefinitionName);
        MetaWebhookEndpoint.WebhookEndpointRuntime endpointRuntime = (MetaWebhookEndpoint.WebhookEndpointRuntime)this.wheps.getRuntimeByName(endpointDefinitionName);
        if (endpointRuntime == null) {
            throw new SystemException("Endpoint Template:" + endpointDefinitionName + " not found");
        }
        if (webhookRuntime == null) {
            throw new SystemException("WebhookTemplate:" + webhookDefinitionName + " not found");
        }
        Webhook webhook = webhookRuntime.createWebhook(binding);
        webhook.setEndpoint(endpointRuntime.createWebhookEndpoint(binding));
        return webhook;
    }

    private void sendWebhook(Webhook webhook) {
        try {
            WebhookResponse webhookResponse;
            if (webhook.getHttpMethod() == null && logger.isDebugEnabled()) {
                logger.debug("Webhook: request method undefined. Post will be used.");
            }
            String url = webhook.getEndpoint().getUrl() + webhook.getPathAndQuery();
            HttpUriRequest httpRequest = this.getReqestMethodObject(webhook.getHttpMethod(), new URI(url));
            logger.debug("Webhook: Endpoint = {}, pathAndQuery = {}, httpMethod = {}", new Object[]{webhook.getEndpoint().getUrl(), webhook.getPathAndQuery(), webhook.getHttpMethod()});
            if (this.isEnclosingRequest(httpRequest)) {
                if (webhook.getPayloadContent() != null && !webhook.getPayloadContent().replaceAll("\\s", "").isEmpty()) {
                    ContentType contentType = ContentType.create((String)webhook.getContentType()).withCharset(this.webhookContentCharset);
                    StringEntity se = new StringEntity(webhook.getPayloadContent(), contentType);
                    httpRequest.setEntity((HttpEntity)se);
                }
            } else if (webhook.getContentType() != null && !webhook.getContentType().replaceAll("\\s", "").isEmpty()) {
                httpRequest.setHeader("Content-Type", (Object)webhook.getContentType());
            }
            if (webhook.getHeaders() != null) {
                for (WebhookHeader headerEntry : webhook.getHeaders()) {
                    httpRequest.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
                }
            }
            if (webhook.getEndpoint() != null) {
                if (webhook.getEndpoint().getHmacKey() != null && !webhook.getEndpoint().getHmacKey().isEmpty()) {
                    String hmacHeader = webhook.getEndpoint().getHmacHashHeader() == null || webhook.getEndpoint().getHmacHashHeader().replaceAll("\\s", "").isEmpty() ? this.webhookHmacTokenDefaultName : webhook.getEndpoint().getHmacHashHeader().replaceAll("\\s", "");
                    httpRequest.setHeader(hmacHeader, (Object)this.getHmacSha256(webhook.getEndpoint().getHmacKey(), webhook.getPayloadContent()));
                }
                if (webhook.getEndpoint().getHeaderAuthorizationType() != null) {
                    String scheme = "";
                    String authContent = "";
                    if (WebhookAuthenticationType.BEARER.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        scheme = "Bearer";
                        authContent = webhook.getEndpoint().getHeaderAuthorizationContent();
                    } else if (WebhookAuthenticationType.BASIC.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        scheme = "Basic";
                        if (webhook.getEndpoint().getHeaderAuthorizationContent() != null && !webhook.getEndpoint().getHeaderAuthorizationContent().replaceAll("\\s+", "").isEmpty()) {
                            authContent = Base64.encodeBase64String((byte[])webhook.getEndpoint().getHeaderAuthorizationContent().getBytes());
                        }
                    } else if (WebhookAuthenticationType.CUSTOM.equals((Object)webhook.getEndpoint().getHeaderAuthorizationType())) {
                        String authTypeName;
                        scheme = "Custom";
                        if (webhook.getEndpoint().getHeaderAuthCustomTypeName() != null && !(authTypeName = webhook.getEndpoint().getHeaderAuthCustomTypeName().replace("\n", "").replaceAll("\\s+", "")).isEmpty()) {
                            scheme = authTypeName;
                        }
                        authContent = webhook.getEndpoint().getHeaderAuthorizationContent();
                    }
                    if (authContent != null && !authContent.replaceAll("\\s+", "").isEmpty()) {
                        httpRequest.setHeader("Authorization", (Object)(scheme + " " + authContent));
                    }
                }
            }
            if (null != (webhookResponse = this.doSendWebhookRequest(httpRequest))) {
                if (webhook.getResponseHandler() == null) {
                    webhook.setResponseHandler(new DefaultWebhookResponseHandler());
                }
                webhook.getResponseHandler().handleResponse(webhookResponse);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private WebhookResponse doSendWebhookRequest(HttpUriRequest request) {
        if (this.webhookIsRetry) {
            for (int i = 0; i < this.webhookRetryMaximumAttpempts; ++i) {
                try {
                    return (WebhookResponse)this.webhookHttpClient.execute((ClassicHttpRequest)request, response -> this.generateWebhookResponse(response));
                }
                catch (Exception e) {
                    if (e.getClass() == InterruptedIOException.class || e.getClass() == UnknownHostException.class || e.getClass() == ConnectException.class || e.getClass() == SSLException.class) {
                        logger.info("Webhook:" + e.getClass().getName() + " has occured. Stop retrying.");
                        break;
                    }
                    try {
                        Thread.sleep(this.webhookRetryInterval);
                        continue;
                    }
                    catch (InterruptedException exception) {
                        logger.warn("An Webhook retry interval is interrupted, stop retrying.");
                        break;
                    }
                }
            }
        } else {
            try {
                return (WebhookResponse)this.webhookHttpClient.execute((ClassicHttpRequest)request, response -> this.generateWebhookResponse(response));
            }
            catch (IOException e) {
                logger.warn("Webhook: {} has occured.", (Object)e.getClass().getName(), (Object)e);
            }
        }
        return null;
    }

    private String getHmacSha256(String secret, String message) {
        try {
            Mac Hmac = Mac.getInstance(this.webhookHmacHashAlgorithm);
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes("UTF-8"), this.webhookHmacHashAlgorithm);
            Hmac.init(secret_key);
            String hash = Base64.encodeBase64String((byte[])Hmac.doFinal(message.getBytes("UTF-8")));
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private HttpUriRequest getReqestMethodObject(String methodName, URI uri) {
        if (methodName.equals("GET")) {
            return new HttpGet(uri);
        }
        if (methodName.equals("POST")) {
            return new HttpPost(uri);
        }
        if (methodName.equals("DELETE")) {
            return new HttpDelete(uri);
        }
        if (methodName.equals("PUT")) {
            return new HttpPut(uri);
        }
        if (methodName.equals("PATCH")) {
            return new HttpPatch(uri);
        }
        return new HttpPost(uri);
    }

    private boolean isEnclosingRequest(HttpUriRequest request) {
        return request.getMethod().equals("PATCH") || request.getMethod().equals("POST") || request.getMethod().equals("PUT");
    }

    private WebhookResponse generateWebhookResponse(ClassicHttpResponse response) {
        WebhookResponse whr = new WebhookResponse();
        whr.setStatusCode(response.getCode());
        whr.setReasonPhrase(response.getReasonPhrase());
        if (response.getEntity() == null) {
            whr.setContentType(null);
            whr.setContentEncoding(null);
            whr.setResponseBody(null);
        } else {
            try {
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                whr.setResponseBody(entity);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            whr.setContentType(response.getEntity().getContentType());
            whr.setContentEncoding(response.getEntity().getContentEncoding());
        }
        ArrayList<WebhookHeader> headers = new ArrayList<WebhookHeader>();
        if (response.getHeaders() != null) {
            for (Header hd : response.getHeaders()) {
                headers.add(new WebhookHeader(hd.getName(), hd.getValue()));
            }
        }
        whr.setHeaders(headers);
        return whr;
    }

    private class WebhookCallable
    implements Callable<Void> {
        Webhook webhook;

        public WebhookCallable(Webhook webhook) {
            this.webhook = webhook;
        }

        @Override
        public Void call() throws Exception {
            WebhookServiceImpl.this.sendWebhook(this.webhook);
            return null;
        }
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<WebhookTemplateDefinition, MetaWebhookTemplate> {
        public TypeMap() {
            super(WebhookServiceImpl.getFixedPath(), MetaWebhookTemplate.class, WebhookTemplateDefinition.class);
        }

        @Override
        public TypedDefinitionManager<WebhookTemplateDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(WebhookTemplateDefinitionManager.class);
        }
    }
}

