/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook.endpoint;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.webhook.endpoint.WebhookEndpointService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webhook.endpoint.WebhookAuthenticationType;
import org.iplass.mtp.webhook.endpoint.WebhookEndpoint;
import org.iplass.mtp.webhook.endpoint.definition.WebhookEndpointDefinition;

@XmlRootElement
public class MetaWebhookEndpoint
extends BaseRootMetaData
implements DefinableMetaData<WebhookEndpointDefinition> {
    private static final long serialVersionUID = 7029271819447338103L;
    private WebhookAuthenticationType headerAuthType;
    private String headerAuthCustomTypeName;
    private String url;
    private boolean hmacEnabled;
    private String hmacHashHeader;

    @Override
    public void applyConfig(WebhookEndpointDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.url = definition.getUrl();
        this.headerAuthCustomTypeName = definition.getHeaderAuthCustomTypeName();
        this.hmacHashHeader = definition.getHmacHashHeader();
        this.hmacEnabled = definition.isHmacEnabled();
        this.headerAuthType = this.getByTypeCode(definition.getHeaderAuthType());
    }

    @Override
    public WebhookEndpointDefinition currentConfig() {
        WebhookEndpointDefinition definition = new WebhookEndpointDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setHeaderAuthType(this.getTypeCodeString(this.headerAuthType));
        definition.setHeaderAuthCustomTypeName(this.headerAuthCustomTypeName);
        definition.setUrl(this.url);
        definition.setHmacHashHeader(this.hmacHashHeader);
        definition.setHmacEnabled(this.hmacEnabled);
        return definition;
    }

    public MetaWebhookEndpoint() {
    }

    public MetaWebhookEndpoint(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = "";
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookAuthenticationType getHeaderAuthType() {
        return this.headerAuthType;
    }

    public void setHeaderAuthType(WebhookAuthenticationType headerAuthType) {
        this.headerAuthType = headerAuthType;
    }

    public String getHeaderAuthCustomTypeName() {
        return this.headerAuthCustomTypeName;
    }

    public void setHeaderAuthCustomTypeName(String headerAuthCustomTypeName) {
        this.headerAuthCustomTypeName = headerAuthCustomTypeName;
    }

    @Override
    public WebhookEndpointRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new WebhookEndpointRuntime();
    }

    @Override
    public RootMetaData copy() {
        return ObjectUtil.deepCopy(this);
    }

    public String getHmacHashHeader() {
        return this.hmacHashHeader;
    }

    public void setHmacHashHeader(String hmacHashHeader) {
        this.hmacHashHeader = hmacHashHeader;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    public void setHmacEnabled(boolean hmacEnabled) {
        this.hmacEnabled = hmacEnabled;
    }

    private WebhookAuthenticationType getByTypeCode(String typeCode) {
        if ("WHBA".equals(typeCode)) {
            return WebhookAuthenticationType.BASIC;
        }
        if ("WHBT".equals(typeCode)) {
            return WebhookAuthenticationType.BEARER;
        }
        if ("WHCT".equals(typeCode)) {
            return WebhookAuthenticationType.CUSTOM;
        }
        return null;
    }

    private String getTypeCodeString(WebhookAuthenticationType type) {
        if (type == null) {
            return null;
        }
        if (WebhookAuthenticationType.BASIC.equals((Object)type)) {
            return "WHBA";
        }
        if (WebhookAuthenticationType.BEARER.equals((Object)type)) {
            return "WHBT";
        }
        if (WebhookAuthenticationType.CUSTOM.equals((Object)type)) {
            return "WHCT";
        }
        return null;
    }

    public class WebhookEndpointRuntime
    extends BaseMetaDataRuntime {
        private GroovyTemplate urlTemplate;
        private String hmacKey;
        private String headerAuthToken;

        public WebhookEndpointRuntime() {
            WebhookEndpointService service = ServiceRegistry.getRegistry().getService(WebhookEndpointService.class);
            int tenantId = ExecuteContext.getCurrentContext().getTenantContext().getTenantId();
            this.hmacKey = service.getHmacTokenById(tenantId, MetaWebhookEndpoint.this.getId());
            if (WebhookAuthenticationType.BASIC.equals((Object)MetaWebhookEndpoint.this.getHeaderAuthType())) {
                this.headerAuthToken = service.getBasicTokenById(tenantId, MetaWebhookEndpoint.this.getId());
            } else if (WebhookAuthenticationType.BEARER.equals((Object)MetaWebhookEndpoint.this.getHeaderAuthType())) {
                this.headerAuthToken = service.getBearerTokenById(tenantId, MetaWebhookEndpoint.this.getId());
            } else if (WebhookAuthenticationType.CUSTOM.equals((Object)MetaWebhookEndpoint.this.getHeaderAuthType())) {
                this.headerAuthToken = service.getCustomTokenById(tenantId, MetaWebhookEndpoint.this.getId());
            }
            try {
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.urlTemplate = GroovyTemplateCompiler.compile(MetaWebhookEndpoint.this.getUrl(), "WebhookEndpointTemplate_" + MetaWebhookEndpoint.this.getName() + "_UrlTemplate", (GroovyScriptEngine)se);
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public WebhookEndpoint createWebhookEndpoint(Map<String, Object> parameter) {
            HashMap<String, Object> binding = new HashMap<String, Object>();
            if (parameter != null) {
                for (Map.Entry<String, Object> e : parameter.entrySet()) {
                    binding.put(e.getKey(), e.getValue());
                }
            }
            String resultUrl = "";
            if (this.urlTemplate != null) {
                StringWriter sw = new StringWriter();
                GroovyTemplateBinding gtb = new GroovyTemplateBinding(sw, binding);
                try {
                    this.urlTemplate.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                resultUrl = sw.toString();
            }
            WebhookEndpoint endpoint = new WebhookEndpoint(resultUrl, MetaWebhookEndpoint.this.getHeaderAuthType(), this.headerAuthToken, this.hmacKey);
            if (!MetaWebhookEndpoint.this.hmacEnabled) {
                this.hmacKey = null;
            }
            if (MetaWebhookEndpoint.this.hmacHashHeader != null && !MetaWebhookEndpoint.this.hmacHashHeader.replaceAll("\\s", "").isEmpty()) {
                endpoint.setHmacHashHeader(MetaWebhookEndpoint.this.hmacHashHeader.replaceAll("\\s", ""));
            }
            if (MetaWebhookEndpoint.this.headerAuthCustomTypeName != null && !MetaWebhookEndpoint.this.headerAuthCustomTypeName.replaceAll("\\s", "").isEmpty()) {
                endpoint.setHeaderAuthCustomTypeName(MetaWebhookEndpoint.this.headerAuthCustomTypeName.replaceAll("\\s", ""));
            }
            return endpoint;
        }

        @Override
        public MetaWebhookEndpoint getMetaData() {
            return MetaWebhookEndpoint.this;
        }

        public GroovyTemplate getUrlTemplate() {
            return this.urlTemplate;
        }

        public String getHmacKey() {
            return this.hmacKey;
        }

        public String getHeaderAuthToken() {
            return this.headerAuthToken;
        }

        public WebhookAuthenticationType getAuthType() {
            return MetaWebhookEndpoint.this.headerAuthType;
        }

        public String getHmacHashHeader() {
            return MetaWebhookEndpoint.this.hmacHashHeader;
        }

        public String getHeaderAuthCustomTypeName() {
            return MetaWebhookEndpoint.this.headerAuthCustomTypeName;
        }

        public boolean isHmacEnabled() {
            return MetaWebhookEndpoint.this.hmacEnabled;
        }
    }
}

