/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook.endpoint;

import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.webhook.WebhookAuthTokenHandler;
import org.iplass.mtp.impl.webhook.endpoint.MetaWebhookEndpoint;
import org.iplass.mtp.impl.webhook.endpoint.WebhookEndpointService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webhook.endpoint.WebhookEndpoint;
import org.iplass.mtp.webhook.endpoint.definition.WebhookEndpointDefinition;
import org.iplass.mtp.webhook.endpoint.definition.WebhookEndpointDefinitionManager;

public class WebhookEndpointServiceImpl
extends AbstractTypedMetaDataService<MetaWebhookEndpoint, MetaWebhookEndpoint.WebhookEndpointRuntime>
implements WebhookEndpointService {
    WebhookAuthTokenHandler tokenHandler;
    public static final String WEBHOOKENDPOINT_DEFINITION_META_PATH = "/webhook/endpoint/";

    @Override
    public void init(Config config) {
        this.tokenHandler = (WebhookAuthTokenHandler)ServiceRegistry.getRegistry().getService(AuthTokenService.class).getHandler("WEBHOOKATH");
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<MetaWebhookEndpoint> getMetaDataType() {
        return MetaWebhookEndpoint.class;
    }

    @Override
    public Class<MetaWebhookEndpoint.WebhookEndpointRuntime> getRuntimeType() {
        return MetaWebhookEndpoint.WebhookEndpointRuntime.class;
    }

    @Override
    public void deleteSecurityTokenById(String metaDataId) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        WebhookAuthTokenHandler tokenHandler = (WebhookAuthTokenHandler)ServiceRegistry.getRegistry().getService(AuthTokenService.class).getHandler("WEBHOOKATH");
        String series = metaDataId;
        tokenHandler.deleteSecret(tenantId, "WHBA", series);
        tokenHandler.deleteSecret(tenantId, "WHBT", series);
        tokenHandler.deleteSecret(tenantId, "WHHM", series);
        tokenHandler.deleteSecret(tenantId, "WHCT", series);
    }

    @Override
    public void updateBasicSecurityTokenById(int tenantId, String metaDataId, String basic) {
        if (basic == null || basic.isEmpty()) {
            this.tokenHandler.deleteSecret(tenantId, "WHBA", metaDataId);
        } else if (this.getBasicTokenById(tenantId, metaDataId) == null) {
            String secret = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])basic.getBytes());
            this.tokenHandler.insertSecret(tenantId, "WHBA", metaDataId, metaDataId, secret);
        } else {
            String secret = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])basic.getBytes());
            this.tokenHandler.updateSecret(tenantId, "WHBA", metaDataId, metaDataId, secret);
        }
    }

    @Override
    public void updateBearerSecurityTokenById(int tenantId, String metaDataId, String secret) {
        if (secret == null || secret.isEmpty()) {
            this.tokenHandler.deleteSecret(tenantId, "WHBT", metaDataId);
        } else if (this.getBearerTokenById(tenantId, metaDataId) == null) {
            this.tokenHandler.insertSecret(tenantId, "WHBT", metaDataId, metaDataId, secret);
        } else {
            this.tokenHandler.updateSecret(tenantId, "WHBT", metaDataId, metaDataId, secret);
        }
    }

    @Override
    public void updateHmacSecurityTokenById(int tenantId, String metaDataId, String secret) {
        if (secret == null || secret.isEmpty()) {
            this.tokenHandler.deleteSecret(tenantId, "WHHM", metaDataId);
        } else if (this.getHmacTokenById(tenantId, metaDataId) == null) {
            this.tokenHandler.insertSecret(tenantId, "WHHM", metaDataId, metaDataId, secret);
        } else {
            this.tokenHandler.updateSecret(tenantId, "WHHM", metaDataId, metaDataId, secret);
        }
    }

    @Override
    public String getBasicTokenById(int tenantId, String metaDataId) {
        String base64 = this.tokenHandler.getSecret(tenantId, metaDataId, "WHBA");
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        String token = new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)base64));
        return token;
    }

    @Override
    public String getBearerTokenById(int tenantId, String metaDataId) {
        String token = this.tokenHandler.getSecret(tenantId, metaDataId, "WHBT");
        return token;
    }

    @Override
    public String getHmacTokenById(int tenantId, String metaDataId) {
        String token = this.tokenHandler.getSecret(tenantId, metaDataId, "WHHM");
        return token;
    }

    @Override
    public String generateHmacTokenString() {
        KeyGenerator keyGen;
        try {
            keyGen = KeyGenerator.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SecretKey secretKey = keyGen.generateKey();
        String encodedKey = Base64.getEncoder().encodeToString(secretKey.getEncoded());
        return encodedKey;
    }

    @Override
    public void deleteSecurityTokenByDefinitionName(String definitionName) {
        this.deleteSecurityTokenById(this.getMetaIdByDefinitionName(definitionName));
    }

    @Override
    public void updateBasicSecurityTokenByDefinitionName(int tenantId, String definitionName, String basic) {
        this.updateBasicSecurityTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName), basic);
    }

    @Override
    public void updateHmacSecurityTokenByDefinitionName(int tenantId, String definitionName, String secret) {
        this.updateHmacSecurityTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName), secret);
    }

    @Override
    public void updateBearerSecurityTokenByDefinitionName(int tenantId, String definitionName, String secret) {
        this.updateBearerSecurityTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName), secret);
    }

    @Override
    public String getHmacTokenByDefinitionName(int tenantId, String definitionName) {
        return this.getHmacTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName));
    }

    @Override
    public String getBearerTokenByDefinitionName(int tenantId, String definitionName) {
        return this.getBearerTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName));
    }

    @Override
    public String getBasicTokenByDefinitionName(int tenantId, String definitionName) {
        return this.getBasicTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName));
    }

    public GroovyTemplate getUrlTemplateByName(String definitionName) {
        return ((MetaWebhookEndpoint.WebhookEndpointRuntime)this.getRuntimeByName(definitionName)).getUrlTemplate();
    }

    @Override
    public void updateCustomSecurityTokenByDefinitionName(int tenantId, String definitionName, String secret) {
        this.updateCustomSecurityTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName), secret);
    }

    @Override
    public void updateCustomSecurityTokenById(int tenantId, String metaDataId, String secret) {
        if (secret == null || secret.isEmpty()) {
            this.tokenHandler.deleteSecret(tenantId, "WHCT", metaDataId);
        } else if (this.getCustomTokenById(tenantId, metaDataId) == null) {
            this.tokenHandler.insertSecret(tenantId, "WHCT", metaDataId, metaDataId, secret);
        } else {
            this.tokenHandler.updateSecret(tenantId, "WHCT", metaDataId, metaDataId, secret);
        }
    }

    @Override
    public String getCustomTokenByDefinitionName(int tenantId, String definitionName) {
        return this.getCustomTokenById(tenantId, this.getMetaIdByDefinitionName(definitionName));
    }

    @Override
    public String getCustomTokenById(int tenantId, String metaDataId) {
        String token = this.tokenHandler.getSecret(tenantId, metaDataId, "WHCT");
        return token;
    }

    @Override
    public String getSecurityToken(int tenantId, String definitionName, String tokenType) {
        if (tokenType == null || tokenType.replaceAll("\\s", "").isEmpty()) {
            return null;
        }
        if ("WHHM".equals(tokenType)) {
            return this.getHmacTokenByDefinitionName(tenantId, definitionName);
        }
        if ("WHBT".equals(tokenType)) {
            return this.getBearerTokenByDefinitionName(tenantId, definitionName);
        }
        if ("WHBA".equals(tokenType)) {
            return this.getBasicTokenByDefinitionName(tenantId, definitionName);
        }
        if ("WHCT".equals(tokenType)) {
            return this.getCustomTokenByDefinitionName(tenantId, definitionName);
        }
        throw new RuntimeException("unknown TokenType");
    }

    @Override
    public WebhookEndpoint getWebhookEndpointByDefinitionName(String definitionName, Map<String, Object> binding) {
        return ((MetaWebhookEndpoint.WebhookEndpointRuntime)this.getRuntimeByName(definitionName)).createWebhookEndpoint(binding);
    }

    private String getMetaIdByDefinitionName(String definitionName) {
        String path = DefinitionService.getInstance().getPathByMeta(MetaWebhookEndpoint.class, definitionName);
        MetaDataEntry entry = MetaDataContext.getContext().getMetaDataEntry(path);
        return entry.getMetaData().getId();
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<WebhookEndpointDefinition, MetaWebhookEndpoint> {
        public TypeMap() {
            super(TypeMap.getFixedPath(), MetaWebhookEndpoint.class, WebhookEndpointDefinition.class);
        }

        public static String getFixedPath() {
            return WebhookEndpointServiceImpl.WEBHOOKENDPOINT_DEFINITION_META_PATH;
        }

        @Override
        public TypedDefinitionManager<WebhookEndpointDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(WebhookEndpointDefinitionManager.class);
        }
    }
}

