/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webhook.template;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.webhook.template.MetaWebhookHeader;
import org.iplass.mtp.webhook.Webhook;
import org.iplass.mtp.webhook.WebhookHeader;
import org.iplass.mtp.webhook.template.definition.WebhookHeaderDefinition;
import org.iplass.mtp.webhook.template.definition.WebhookTemplateDefinition;

@XmlRootElement
public class MetaWebhookTemplate
extends BaseRootMetaData
implements DefinableMetaData<WebhookTemplateDefinition> {
    private static final long serialVersionUID = 6383360434482999137L;
    private String contentType;
    private String webhookContent;
    private String httpMethod;
    private List<MetaWebhookHeader> headers;
    private String pathAndQuery;

    @Override
    public WebhookTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new WebhookTemplateRuntime();
    }

    @Override
    public MetaWebhookTemplate copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(WebhookTemplateDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.contentType = definition.getContentType();
        this.webhookContent = definition.getWebhookContent();
        this.httpMethod = definition.getHttpMethod();
        this.pathAndQuery = definition.getPathAndQuery();
        ArrayList<MetaWebhookHeader> newHeaders = new ArrayList<MetaWebhookHeader>();
        if (definition.getHeaders() != null) {
            for (WebhookHeaderDefinition headerDefinition : definition.getHeaders()) {
                MetaWebhookHeader temp = new MetaWebhookHeader();
                temp.applyConfig(headerDefinition);
                newHeaders.add(temp);
            }
        }
        this.headers = newHeaders;
    }

    @Override
    public WebhookTemplateDefinition currentConfig() {
        WebhookTemplateDefinition definition = new WebhookTemplateDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setContentType(this.contentType);
        definition.setWebhookContent(this.webhookContent);
        definition.setPathAndQuery(this.pathAndQuery);
        definition.setHttpMethod(this.httpMethod);
        ArrayList<WebhookHeaderDefinition> newHeaders = new ArrayList<WebhookHeaderDefinition>();
        if (this.headers != null) {
            for (MetaWebhookHeader metaHeader : this.headers) {
                newHeaders.add(metaHeader.currentConfig());
            }
        }
        definition.setHeaders(newHeaders);
        return definition;
    }

    public List<MetaWebhookHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<MetaWebhookHeader> headers) {
        this.headers = headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = "";
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getWebhookContent() {
        if (this.webhookContent == null) {
            this.webhookContent = "";
        }
        return this.webhookContent;
    }

    public String getPathAndQuery() {
        if (this.pathAndQuery == null) {
            this.pathAndQuery = "";
        }
        return this.pathAndQuery;
    }

    public void setPathAndQuery(String pathAndQuery) {
        this.pathAndQuery = pathAndQuery;
    }

    public void setWebhookContent(String webhookContent) {
        this.webhookContent = webhookContent;
    }

    public class WebhookTemplateRuntime
    extends BaseMetaDataRuntime {
        private GroovyTemplate contentTemplate;
        private GroovyTemplate pathAndQueryTemplate;

        public WebhookTemplateRuntime() {
            try {
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.contentTemplate = GroovyTemplateCompiler.compile(MetaWebhookTemplate.this.getWebhookContent(), "WebhookTemplate_" + MetaWebhookTemplate.this.getName() + "_Content", (GroovyScriptEngine)se);
                this.pathAndQueryTemplate = GroovyTemplateCompiler.compile(MetaWebhookTemplate.this.getPathAndQuery(), "WebhookTemplate_" + MetaWebhookTemplate.this.getName() + "_PathAndQuery_", (GroovyScriptEngine)se);
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public GroovyTemplate getPathAndQueryTemplate() {
            return this.pathAndQueryTemplate;
        }

        public GroovyTemplate getContentTemplate() {
            return this.contentTemplate;
        }

        @Override
        public MetaWebhookTemplate getMetaData() {
            return MetaWebhookTemplate.this;
        }

        public Webhook createWebhook(Map<String, Object> parameter) {
            this.checkState();
            Webhook webhook = new Webhook();
            ArrayList<WebhookHeader> newHeaders = new ArrayList<WebhookHeader>();
            if (MetaWebhookTemplate.this.headers != null) {
                for (MetaWebhookHeader metaWebhookHeader : MetaWebhookTemplate.this.headers) {
                    newHeaders.add(new WebhookHeader(metaWebhookHeader.getKey(), metaWebhookHeader.getValue()));
                }
            }
            webhook.setHeaders(newHeaders);
            webhook.setHttpMethod(MetaWebhookTemplate.this.httpMethod);
            webhook.setContentType(MetaWebhookTemplate.this.contentType);
            webhook.setPathAndQuery(MetaWebhookTemplate.this.pathAndQuery);
            HashMap<String, Object> binding = new HashMap<String, Object>();
            if (parameter != null) {
                for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                    binding.put(entry.getKey(), entry.getValue());
                }
            }
            webhook.setContentType(MetaWebhookTemplate.this.contentType);
            binding.put("webhook", webhook);
            if (this.contentTemplate != null) {
                StringWriter stringWriter = new StringWriter();
                GroovyTemplateBinding groovyTemplateBinding = new GroovyTemplateBinding(stringWriter, binding);
                try {
                    this.contentTemplate.doTemplate(groovyTemplateBinding);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                webhook.setPayloadContent(stringWriter.toString());
            }
            if (this.pathAndQueryTemplate != null) {
                StringWriter stringWriter = new StringWriter();
                GroovyTemplateBinding groovyTemplateBinding = new GroovyTemplateBinding(stringWriter, binding);
                try {
                    this.pathAndQueryTemplate.doTemplate(groovyTemplateBinding);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                webhook.setPathAndQuery(stringWriter.toString());
            }
            return webhook;
        }
    }
}

