/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.xml.jaxb;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.iplass.mtp.impl.xml.jaxb.XmlDataTypeFactory;

@XmlType(name="dateTime", namespace="http://www.w3.org/2001/XMLSchema")
public class XmlDateTime {
    @XmlValue
    String value;

    public XmlDateTime() {
    }

    public XmlDateTime(Timestamp dateTime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateTime);
        XMLGregorianCalendar xmlCal = XmlDataTypeFactory.factory.newXMLGregorianCalendar(cal);
        xmlCal.setFractionalSecond(new BigDecimal(BigInteger.valueOf(dateTime.getNanos()), 9));
        this.value = xmlCal.toXMLFormat();
    }

    public Timestamp toTimestamp() {
        XMLGregorianCalendar xmlCal = XmlDataTypeFactory.factory.newXMLGregorianCalendar(this.value);
        GregorianCalendar cal = xmlCal.toGregorianCalendar();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        if (xmlCal.getFractionalSecond() != null) {
            ts.setNanos(xmlCal.getFractionalSecond().movePointRight(9).intValue());
        }
        return ts;
    }

    public String toString() {
        return "XmlDateTime [value=" + this.value + "]";
    }

    public String toXmlString() {
        return this.value;
    }
}

