/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.prefs;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.prefs.Preference;

@XmlRootElement
public class PreferenceSet
extends Preference {
    private static final long serialVersionUID = -6340236717961297709L;
    private List<Preference> subSet;
    private transient Map<String, Preference[]> map;

    public PreferenceSet() {
    }

    public PreferenceSet(String name, List<Preference> subSet) {
        super(name, null);
        this.subSet = subSet;
    }

    public PreferenceSet(String name, Preference ... prefs) {
        this(name, (String)null, prefs);
    }

    public PreferenceSet(String name, String runtimeClassName, Preference ... prefs) {
        super(name, null);
        this.setRuntimeClassName(runtimeClassName);
        this.subSet = new ArrayList<Preference>();
        if (prefs != null) {
            for (Preference p : prefs) {
                this.subSet.add(p);
            }
        }
    }

    public List<Preference> getSubSet() {
        return this.subSet;
    }

    public void setSubSet(List<Preference> subSet) {
        this.subSet = subSet;
    }

    public String getValue(String subPath, String defaultValue) {
        Object p = this.getPrefCascade(subPath);
        if (p == null) {
            return defaultValue;
        }
        if (p instanceof Preference[]) {
            return ((Preference[])p)[0].getValue(defaultValue);
        }
        return ((Preference)p).getValue(defaultValue);
    }

    private void initMap() {
        if (this.map == null) {
            if (this.subSet == null) {
                this.map = Collections.emptyMap();
            } else {
                this.map = new HashMap<String, Preference[]>();
                for (Preference p : this.subSet) {
                    Preference[] pre = this.map.get(p.getName());
                    if (pre == null) {
                        this.map.put(p.getName(), new Preference[]{p});
                        continue;
                    }
                    Preference[] newPre = new Preference[pre.length + 1];
                    System.arraycopy(pre, 0, newPre, 0, pre.length);
                    newPre[pre.length] = p;
                    this.map.put(p.getName(), newPre);
                }
            }
        }
    }

    private Object getPrefCascade(String path) {
        String subName;
        String path1;
        this.initMap();
        int sl = path.indexOf(47);
        String path2 = null;
        if (sl > 0) {
            path1 = path.substring(0, sl);
            path2 = path.substring(sl + 1);
        } else {
            path1 = path;
        }
        int index = -1;
        int pa1 = path1.indexOf(91);
        int pa2 = path1.indexOf(93);
        if (pa1 > 0) {
            if (pa2 <= 0 || pa1 >= pa2) {
                throw new ArrayIndexOutOfBoundsException("cant parse array expression:" + path);
            }
            index = Integer.parseInt(path1.substring(pa1 + 1, pa2));
            subName = path1.substring(0, pa1);
        } else {
            subName = path1;
        }
        Preference[] subp = this.map.get(subName);
        if (subp == null) {
            return null;
        }
        if (index == -1) {
            if (path2 == null) {
                return subp;
            }
            return ((PreferenceSet)subp[0]).getPrefCascade(path2);
        }
        if (path2 == null) {
            return subp[index];
        }
        return ((PreferenceSet)subp[index]).getPrefCascade(path2);
    }

    public Preference[] getSubSet(String subPath) {
        Object p = this.getPrefCascade(subPath);
        if (p == null) {
            return new Preference[0];
        }
        if (p instanceof Preference) {
            return new Preference[]{(Preference)p};
        }
        return (Preference[])p;
    }
}

