/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.core.config.ConfigImpl;
import org.iplass.mtp.impl.core.config.ServiceConfig;
import org.iplass.mtp.impl.core.config.ServiceDefinition;
import org.iplass.mtp.impl.core.config.ServiceDefinitionParser;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private static ServiceRegistry registry = new ServiceRegistry();
    private final ConcurrentHashMap<String, ServiceEntry> services = new ConcurrentHashMap(32, 0.75f, 1);
    private final ServiceDefinitionParser parser = new ServiceDefinitionParser();
    private volatile ServiceDefinition serviceDefinition = this.parser.read(this.configFileName());
    private volatile boolean destroyed = false;

    public static ServiceRegistry getRegistry() {
        return registry;
    }

    private ServiceRegistry() {
    }

    private String configFileName() {
        return BootstrapProps.getInstance().getProperty("mtp.config", "/mtp-service-config.xml");
    }

    private ServiceEntry createService(String serviceName, List<String> dependStack) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service allready destroyed");
            }
            ServiceEntry service = this.services.get(serviceName);
            if (service != null) {
                return service;
            }
            long start = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug("Service: " + serviceName + " create");
                start = System.currentTimeMillis();
            }
            if (dependStack.contains(serviceName)) {
                throw new ServiceConfigrationException("depend loop occured." + String.valueOf(dependStack) + " " + serviceName);
            }
            dependStack.add(serviceName);
            ServiceConfig sc = this.serviceDefinition.search(serviceName);
            if (sc == null) {
                throw new ServiceConfigrationException(serviceName + " not defined.");
            }
            ConfigImpl config = new ConfigImpl(serviceName, sc.getProperty(), sc.getBean());
            if (sc.getDepend() != null) {
                for (String depend : sc.getDepend()) {
                    ServiceEntry dependService = this.services.get(depend);
                    if (dependService == null) {
                        dependService = this.createService(depend, dependStack);
                    }
                    config.addDependentService(depend, dependService.service);
                }
            }
            try {
                Class<?> implClassType;
                Class<?> interfaceType = Class.forName(sc.getInterfaceName());
                if (!Service.class.isAssignableFrom(interfaceType)) {
                    logger.error("Can not regist Service." + sc.getInterfaceName() + "must implements Service interface.");
                    throw new ServiceConfigrationException("Can not regist Service." + sc.getInterfaceName() + "must implements Service interface.");
                }
                String className = sc.getClassName();
                if (className == null) {
                    className = sc.getInterfaceName();
                }
                if (!interfaceType.isAssignableFrom(implClassType = Class.forName(className))) {
                    logger.error("Can not regist Service." + sc.getClassName() + "must implements " + sc.getInterfaceName() + " interface.");
                    throw new ServiceConfigrationException("Can not regist Service." + sc.getClassName() + " must implements " + sc.getInterfaceName() + " interface.");
                }
                Service s = (Service)implClassType.newInstance();
                s.init(config);
                config.notifyInited(s);
                ServiceEntry se = new ServiceEntry(serviceName, s, config);
                this.services.put(serviceName, se);
                dependStack.remove(serviceName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Service: " + serviceName + " created in " + (System.currentTimeMillis() - start) + "ms.");
                }
                return se;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException e) {
                throw new ServiceConfigrationException("failed to create Service:" + serviceName, e);
            }
        }
    }

    public <T extends Service> T getService(Class<T> serviceClass) {
        return this.getService(serviceClass.getName(), true);
    }

    public <T extends Service> T getService(String serviceName) {
        return this.getService(serviceName, true);
    }

    public <T extends Service> T getService(Class<T> serviceClass, boolean createIfNone) {
        return this.getService(serviceClass.getName(), createIfNone);
    }

    public <T extends Service> T getService(String serviceName, boolean createIfNone) {
        ServiceEntry se = this.services.get(serviceName);
        if (se == null) {
            if (!createIfNone) {
                logger.debug("Service: {} not created. Because the parameter 'createIfNone' is false.", (Object)serviceName);
                return null;
            }
            try {
                se = this.createService(serviceName, new ArrayList<String>());
            }
            catch (ServiceConfigrationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ServiceConfigrationException("can not initialize service:" + serviceName, e);
            }
        }
        return (T)se.service;
    }

    public <T extends Service> boolean exists(Class<T> serviceClass) {
        return this.exists(serviceClass.getName());
    }

    public boolean exists(String serviceName) {
        return this.serviceDefinition.search(serviceName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setService(String serviceName, Service service) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service already destroyed");
            }
            ServiceEntry previous = this.services.put(serviceName, new ServiceEntry(serviceName, service, null));
            if (previous != null) {
                previous.destroy();
            }
        }
    }

    public void setService(Service service) {
        this.setService(service.getClass().getName(), service);
    }

    public void destroyAllService() {
        this.destroyed = true;
        for (Map.Entry<String, ServiceEntry> e : this.services.entrySet()) {
            e.getValue().destroy();
        }
        this.services.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInit() {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.destroyed) {
                throw new SystemException("service already destroyed");
            }
            ArrayList<ServiceEntry> forDest = new ArrayList<ServiceEntry>(this.services.size());
            for (Map.Entry<String, ServiceEntry> e : this.services.entrySet()) {
                forDest.add(e.getValue());
            }
            this.services.clear();
            this.serviceDefinition = this.parser.read(this.configFileName());
            for (ServiceEntry se : forDest) {
                se.destroy();
            }
        }
    }

    private static class ServiceEntry {
        private final String name;
        private final Service service;
        private final ConfigImpl config;

        ServiceEntry(String name, Service service, ConfigImpl config) {
            this.name = name;
            this.service = service;
            this.config = config;
        }

        void destroy() {
            try {
                this.service.destroy();
                if (this.config != null) {
                    this.config.notifyDestroyed();
                }
            }
            catch (Exception e) {
                logger.error("service:" + this.name + " destroy process faild. so mybe memory leak. cause:" + String.valueOf(e), (Throwable)e);
            }
        }
    }
}

