/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.tenant;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.impl.xml.jaxb.DateXmlAdapter;
import org.iplass.mtp.impl.xml.jaxb.XmlDate;
import org.iplass.mtp.impl.xml.jaxb.XmlDateTime;
import org.iplass.mtp.impl.xml.jaxb.XmlTime;
import org.iplass.mtp.tenant.TenantAuthInfo;
import org.iplass.mtp.tenant.TenantConfig;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.tenant.TenantMailInfo;

@XmlSeeAlso(value={XmlDate.class, XmlTime.class, XmlDateTime.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tenant
implements Definition {
    private static final long serialVersionUID = -1058356358874779414L;
    private int id;
    private String name;
    private String url;
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    private Date from;
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    private Date to;
    private String createUser;
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    private Timestamp createDate;
    private String updateUser;
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    private Timestamp updateDate;
    private String description;
    @MultiLang(itemNameGetter="getName", itemKey="displayName", itemGetter="getDisplayName", itemSetter="setDisplayName", multiLangGetter="getLocalizedDisplayNameList", multiLangSetter="setLocalizedDisplayNameList")
    private String displayName;
    private List<LocalizedStringDefinition> localizedDisplayNameList;
    private Map<String, TenantConfig> tenantConfigs;

    public Tenant() {
    }

    public Tenant(int id, String name, String url) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.setTenantConfig(new TenantAuthInfo());
        this.setTenantConfig(new TenantMailInfo());
        this.setTenantConfig(new TenantI18nInfo());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Timestamp getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Timestamp createDate) {
        this.createDate = createDate;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<LocalizedStringDefinition> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<LocalizedStringDefinition> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public void addLocalizedDisplayName(LocalizedStringDefinition localizedDisplayName) {
        if (this.localizedDisplayNameList == null) {
            this.localizedDisplayNameList = new ArrayList<LocalizedStringDefinition>();
        }
        this.localizedDisplayNameList.add(localizedDisplayName);
    }

    public List<TenantConfig> getTenantConfigs() {
        if (this.tenantConfigs != null) {
            return new ArrayList<TenantConfig>(this.tenantConfigs.values());
        }
        return null;
    }

    public void setTenantConfigs(List<TenantConfig> tenantConfigs) {
        this.tenantConfigs = tenantConfigs != null ? tenantConfigs.stream().collect(Collectors.toMap(config -> config.getClass().getName(), config -> config)) : null;
    }

    public void setTenantConfig(TenantConfig tenantConfig) {
        if (this.tenantConfigs == null) {
            this.tenantConfigs = new HashMap<String, TenantConfig>();
        }
        this.tenantConfigs.put(tenantConfig.getClass().getName(), tenantConfig);
    }

    public <T extends TenantConfig> T getTenantConfig(Class<T> tenantConfigClass) {
        if (this.tenantConfigs != null) {
            return (T)this.tenantConfigs.get(tenantConfigClass.getName());
        }
        return null;
    }

    public <T extends TenantConfig> void removeTenantConfig(Class<T> tenantConfigClass) {
        if (this.tenantConfigs != null) {
            this.tenantConfigs.remove(tenantConfigClass.getName());
        }
    }
}

