/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.transaction;

import java.util.function.Consumer;
import java.util.function.Function;
import org.iplass.mtp.transaction.Holder;
import org.iplass.mtp.transaction.NoTransaction;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionOption;
import org.iplass.mtp.transaction.TransactionStatus;

public interface Transaction {
    public static final Transaction NO_TRANSACTION = new NoTransaction();

    public static Transaction getCurrent() {
        Transaction t = Holder.tm.currentTransaction();
        if (t == null) {
            return NO_TRANSACTION;
        }
        return t;
    }

    public void commit();

    public void rollback();

    public void setRollbackOnly();

    public boolean isRollbackOnly();

    public boolean isReadOnly();

    public TransactionStatus getStatus();

    public void setAttribute(Object var1, Object var2);

    public Object getAttribute(Object var1);

    public Object removeAttribute(Object var1);

    public void addTransactionListener(TransactionListener var1);

    default public void afterCommit(final Runnable func) {
        this.addTransactionListener(new TransactionListener(){

            @Override
            public void afterCommit(Transaction t) {
                func.run();
            }
        });
    }

    default public void afterRollback(final Runnable func) {
        this.addTransactionListener(new TransactionListener(){

            @Override
            public void afterRollback(Transaction t) {
                func.run();
            }
        });
    }

    public static void required(Consumer<Transaction> func) {
        Transaction.with(new TransactionOption(), func);
    }

    public static <R> R required(Function<Transaction, R> func) {
        return Transaction.with(new TransactionOption(), func);
    }

    public static void requiresNew(Consumer<Transaction> func) {
        Transaction.with(new TransactionOption(Propagation.REQUIRES_NEW), func);
    }

    public static <R> R requiresNew(Function<Transaction, R> func) {
        return Transaction.with(new TransactionOption(Propagation.REQUIRES_NEW), func);
    }

    public static void readOnly(Consumer<Transaction> func) {
        Transaction.with(new TransactionOption().readOnly(), func);
    }

    public static <R> R readOnly(Function<Transaction, R> func) {
        return Transaction.with(new TransactionOption().readOnly(), func);
    }

    public static void requiresNewReadOnly(Consumer<Transaction> func) {
        Transaction.with(new TransactionOption(Propagation.REQUIRES_NEW).readOnly(), func);
    }

    public static <R> R requiresNewReadOnly(Function<Transaction, R> func) {
        return Transaction.with(new TransactionOption(Propagation.REQUIRES_NEW).readOnly(), func);
    }

    public static void with(Propagation propagation, Consumer<Transaction> func) {
        Transaction.with(new TransactionOption(propagation), func);
    }

    public static <R> R with(Propagation propagation, Function<Transaction, R> func) {
        return Transaction.with(new TransactionOption(propagation), func);
    }

    public static void with(TransactionOption option, final Consumer<Transaction> func) {
        Holder.tm.doTransaction(option, new Function<Transaction, Void>(){

            @Override
            public Void apply(Transaction t) {
                func.accept(t);
                return null;
            }
        });
    }

    public static <R> R with(TransactionOption option, Function<Transaction, R> func) {
        return Holder.tm.doTransaction(option, func);
    }
}

