DROP TABLE "OBJ_UNIQUE_NUM" CASCADE CONSTRAINT;
CREATE TABLE "OBJ_UNIQUE_NUM" 
(
    "TENANT_ID" NUMBER(7,0) NOT NULL, 
    "OBJ_DEF_ID" VARCHAR2(128) NOT NULL, 
    "COL_NAME" VARCHAR2(36) NOT NULL, 
    "OBJ_ID" VARCHAR2(64) NOT NULL,
    "VAL" NUMBER
)
PARTITION BY RANGE (TENANT_ID) INTERVAL(1)
SUBPARTITION BY HASH (OBJ_DEF_ID) SUBPARTITIONS 8
(
    PARTITION OBJ_UNIQUE_NUM_0 VALUES LESS THAN (1)
)
;

CREATE UNIQUE INDEX "OBJ_UNIQUE_NUM_INDEX1" ON "OBJ_UNIQUE_NUM" ("TENANT_ID", "OBJ_DEF_ID", "COL_NAME", "VAL") LOCAL;
CREATE INDEX "OBJ_UNIQUE_NUM_INDEX2" ON "OBJ_UNIQUE_NUM" ("TENANT_ID", "OBJ_DEF_ID", "OBJ_ID") LOCAL;
