/*
 * Copyright (C) 2011 DENTSU SOKEN INC. All Rights Reserved.
 *
 * Unless you have purchased a commercial license,
 * the following license terms apply:
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package org.iplass.mtp.impl.rdb.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class CallableStatementWrapper implements CallableStatement {

	private CallableStatement wrapped;

	private ConnectionWrapper con;

	CallableStatementWrapper(CallableStatement wrapped, ConnectionWrapper con) {
		this.wrapped = wrapped;
		this.con = con;
	}

	public void addBatch() throws SQLException {
		wrapped.addBatch();
	}

	public void addBatch(String sql) throws SQLException {
		wrapped.addBatch(sql);
	}

	public void cancel() throws SQLException {
		wrapped.cancel();
	}

	public void clearBatch() throws SQLException {
		wrapped.clearBatch();
	}

	public void clearParameters() throws SQLException {
		wrapped.clearParameters();
	}

	public void clearWarnings() throws SQLException {
		wrapped.clearWarnings();
	}

	public void close() throws SQLException {
		wrapped.close();
	}

	public boolean execute() throws SQLException {
		return wrapped.execute();
	}

	public boolean execute(String sql, int autoGeneratedKeys)
			throws SQLException {
		return wrapped.execute(sql, autoGeneratedKeys);
	}

	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return wrapped.execute(sql, columnIndexes);
	}

	public boolean execute(String sql, String[] columnNames)
			throws SQLException {
		return wrapped.execute(sql, columnNames);
	}

	public boolean execute(String sql) throws SQLException {
		return wrapped.execute(sql);
	}

	public int[] executeBatch() throws SQLException {
		return wrapped.executeBatch();
	}

	public ResultSet executeQuery() throws SQLException {
		return new ResultSetWrapper(wrapped.executeQuery(), this);
	}

	public ResultSet executeQuery(String sql) throws SQLException {
		return new ResultSetWrapper(wrapped.executeQuery(sql), this);
	}

	public int executeUpdate() throws SQLException {
		return wrapped.executeUpdate();
	}

	public int executeUpdate(String sql, int autoGeneratedKeys)
			throws SQLException {
		return wrapped.executeUpdate(sql, autoGeneratedKeys);
	}

	public int executeUpdate(String sql, int[] columnIndexes)
			throws SQLException {
		return wrapped.executeUpdate(sql, columnIndexes);
	}

	public int executeUpdate(String sql, String[] columnNames)
			throws SQLException {
		return wrapped.executeUpdate(sql, columnNames);
	}

	public int executeUpdate(String sql) throws SQLException {
		return wrapped.executeUpdate(sql);
	}

	public Array getArray(int parameterIndex) throws SQLException {
		return wrapped.getArray(parameterIndex);
	}

	public Array getArray(String parameterName) throws SQLException {
		return wrapped.getArray(parameterName);
	}

	@SuppressWarnings("deprecation")
	public BigDecimal getBigDecimal(int parameterIndex, int scale)
			throws SQLException {
		return wrapped.getBigDecimal(parameterIndex, scale);
	}

	public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
		return wrapped.getBigDecimal(parameterIndex);
	}

	public BigDecimal getBigDecimal(String parameterName) throws SQLException {
		return wrapped.getBigDecimal(parameterName);
	}

	public Blob getBlob(int parameterIndex) throws SQLException {
		return wrapped.getBlob(parameterIndex);
	}

	public Blob getBlob(String parameterName) throws SQLException {
		return wrapped.getBlob(parameterName);
	}

	public boolean getBoolean(int parameterIndex) throws SQLException {
		return wrapped.getBoolean(parameterIndex);
	}

	public boolean getBoolean(String parameterName) throws SQLException {
		return wrapped.getBoolean(parameterName);
	}

	public byte getByte(int parameterIndex) throws SQLException {
		return wrapped.getByte(parameterIndex);
	}

	public byte getByte(String parameterName) throws SQLException {
		return wrapped.getByte(parameterName);
	}

	public byte[] getBytes(int parameterIndex) throws SQLException {
		return wrapped.getBytes(parameterIndex);
	}

	public byte[] getBytes(String parameterName) throws SQLException {
		return wrapped.getBytes(parameterName);
	}

	public Reader getCharacterStream(int parameterIndex) throws SQLException {
		return wrapped.getCharacterStream(parameterIndex);
	}

	public Reader getCharacterStream(String parameterName) throws SQLException {
		return wrapped.getCharacterStream(parameterName);
	}

	public Clob getClob(int parameterIndex) throws SQLException {
		return wrapped.getClob(parameterIndex);
	}

	public Clob getClob(String parameterName) throws SQLException {
		return wrapped.getClob(parameterName);
	}

	public Connection getConnection() throws SQLException {
		return con;
	}

	public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
		return wrapped.getDate(parameterIndex, cal);
	}

	public Date getDate(int parameterIndex) throws SQLException {
		return wrapped.getDate(parameterIndex);
	}

	public Date getDate(String parameterName, Calendar cal) throws SQLException {
		return wrapped.getDate(parameterName, cal);
	}

	public Date getDate(String parameterName) throws SQLException {
		return wrapped.getDate(parameterName);
	}

	public double getDouble(int parameterIndex) throws SQLException {
		return wrapped.getDouble(parameterIndex);
	}

	public double getDouble(String parameterName) throws SQLException {
		return wrapped.getDouble(parameterName);
	}

	public int getFetchDirection() throws SQLException {
		return wrapped.getFetchDirection();
	}

	public int getFetchSize() throws SQLException {
		return wrapped.getFetchSize();
	}

	public float getFloat(int parameterIndex) throws SQLException {
		return wrapped.getFloat(parameterIndex);
	}

	public float getFloat(String parameterName) throws SQLException {
		return wrapped.getFloat(parameterName);
	}

	public ResultSet getGeneratedKeys() throws SQLException {
		return new ResultSetWrapper(wrapped.getGeneratedKeys(), this);
	}

	public int getInt(int parameterIndex) throws SQLException {
		return wrapped.getInt(parameterIndex);
	}

	public int getInt(String parameterName) throws SQLException {
		return wrapped.getInt(parameterName);
	}

	public long getLong(int parameterIndex) throws SQLException {
		return wrapped.getLong(parameterIndex);
	}

	public long getLong(String parameterName) throws SQLException {
		return wrapped.getLong(parameterName);
	}

	public int getMaxFieldSize() throws SQLException {
		return wrapped.getMaxFieldSize();
	}

	public int getMaxRows() throws SQLException {
		return wrapped.getMaxRows();
	}

	public ResultSetMetaData getMetaData() throws SQLException {
		return wrapped.getMetaData();
	}

	public boolean getMoreResults() throws SQLException {
		return wrapped.getMoreResults();
	}

	public boolean getMoreResults(int current) throws SQLException {
		return wrapped.getMoreResults(current);
	}

	public Reader getNCharacterStream(int parameterIndex) throws SQLException {
		return wrapped.getNCharacterStream(parameterIndex);
	}

	public Reader getNCharacterStream(String parameterName) throws SQLException {
		return wrapped.getNCharacterStream(parameterName);
	}

	public NClob getNClob(int parameterIndex) throws SQLException {
		return wrapped.getNClob(parameterIndex);
	}

	public NClob getNClob(String parameterName) throws SQLException {
		return wrapped.getNClob(parameterName);
	}

	public String getNString(int parameterIndex) throws SQLException {
		return wrapped.getNString(parameterIndex);
	}

	public String getNString(String parameterName) throws SQLException {
		return wrapped.getNString(parameterName);
	}

	public Object getObject(int parameterIndex, Map<String, Class<?>> map)
			throws SQLException {
		return wrapped.getObject(parameterIndex, map);
	}

	public Object getObject(int parameterIndex) throws SQLException {
		return wrapped.getObject(parameterIndex);
	}

	public Object getObject(String parameterName, Map<String, Class<?>> map)
			throws SQLException {
		return wrapped.getObject(parameterName, map);
	}

	public Object getObject(String parameterName) throws SQLException {
		return wrapped.getObject(parameterName);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException {
		return wrapped.getParameterMetaData();
	}

	public int getQueryTimeout() throws SQLException {
		return wrapped.getQueryTimeout();
	}

	public Ref getRef(int parameterIndex) throws SQLException {
		return wrapped.getRef(parameterIndex);
	}

	public Ref getRef(String parameterName) throws SQLException {
		return wrapped.getRef(parameterName);
	}

	public ResultSet getResultSet() throws SQLException {
		return new ResultSetWrapper(wrapped.getResultSet(), this);
	}

	public int getResultSetConcurrency() throws SQLException {
		return wrapped.getResultSetConcurrency();
	}

	public int getResultSetHoldability() throws SQLException {
		return wrapped.getResultSetHoldability();
	}

	public int getResultSetType() throws SQLException {
		return wrapped.getResultSetType();
	}

	public RowId getRowId(int parameterIndex) throws SQLException {
		return wrapped.getRowId(parameterIndex);
	}

	public RowId getRowId(String parameterName) throws SQLException {
		return wrapped.getRowId(parameterName);
	}

	public short getShort(int parameterIndex) throws SQLException {
		return wrapped.getShort(parameterIndex);
	}

	public short getShort(String parameterName) throws SQLException {
		return wrapped.getShort(parameterName);
	}

	public SQLXML getSQLXML(int parameterIndex) throws SQLException {
		return wrapped.getSQLXML(parameterIndex);
	}

	public SQLXML getSQLXML(String parameterName) throws SQLException {
		return wrapped.getSQLXML(parameterName);
	}

	public String getString(int parameterIndex) throws SQLException {
		return wrapped.getString(parameterIndex);
	}

	public String getString(String parameterName) throws SQLException {
		return wrapped.getString(parameterName);
	}

	public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
		return wrapped.getTime(parameterIndex, cal);
	}

	public Time getTime(int parameterIndex) throws SQLException {
		return wrapped.getTime(parameterIndex);
	}

	public Time getTime(String parameterName, Calendar cal) throws SQLException {
		return wrapped.getTime(parameterName, cal);
	}

	public Time getTime(String parameterName) throws SQLException {
		return wrapped.getTime(parameterName);
	}

	public Timestamp getTimestamp(int parameterIndex, Calendar cal)
			throws SQLException {
		return wrapped.getTimestamp(parameterIndex, cal);
	}

	public Timestamp getTimestamp(int parameterIndex) throws SQLException {
		return wrapped.getTimestamp(parameterIndex);
	}

	public Timestamp getTimestamp(String parameterName, Calendar cal)
			throws SQLException {
		return wrapped.getTimestamp(parameterName, cal);
	}

	public Timestamp getTimestamp(String parameterName) throws SQLException {
		return wrapped.getTimestamp(parameterName);
	}

	public int getUpdateCount() throws SQLException {
		return wrapped.getUpdateCount();
	}

	public URL getURL(int parameterIndex) throws SQLException {
		return wrapped.getURL(parameterIndex);
	}

	public URL getURL(String parameterName) throws SQLException {
		return wrapped.getURL(parameterName);
	}

	public SQLWarning getWarnings() throws SQLException {
		return wrapped.getWarnings();
	}

	public boolean isClosed() throws SQLException {
		return wrapped.isClosed();
	}

	public boolean isPoolable() throws SQLException {
		return wrapped.isPoolable();
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return wrapped.isWrapperFor(iface);
	}

	public void registerOutParameter(int parameterIndex, int sqlType, int scale)
			throws SQLException {
		wrapped.registerOutParameter(parameterIndex, sqlType, scale);
	}

	public void registerOutParameter(int parameterIndex, int sqlType,
			String typeName) throws SQLException {
		wrapped.registerOutParameter(parameterIndex, sqlType, typeName);
	}

	public void registerOutParameter(int parameterIndex, int sqlType)
			throws SQLException {
		wrapped.registerOutParameter(parameterIndex, sqlType);
	}

	public void registerOutParameter(String parameterName, int sqlType,
			int scale) throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType, scale);
	}

	public void registerOutParameter(String parameterName, int sqlType,
			String typeName) throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType, typeName);
	}

	public void registerOutParameter(String parameterName, int sqlType)
			throws SQLException {
		wrapped.registerOutParameter(parameterName, sqlType);
	}

	public void setArray(int parameterIndex, Array x) throws SQLException {
		wrapped.setArray(parameterIndex, x);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		wrapped.setAsciiStream(parameterIndex, x, length);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		wrapped.setAsciiStream(parameterIndex, x, length);
	}

	public void setAsciiStream(int parameterIndex, InputStream x)
			throws SQLException {
		wrapped.setAsciiStream(parameterIndex, x);
	}

	public void setAsciiStream(String parameterName, InputStream x, int length)
			throws SQLException {
		wrapped.setAsciiStream(parameterName, x, length);
	}

	public void setAsciiStream(String parameterName, InputStream x, long length)
			throws SQLException {
		wrapped.setAsciiStream(parameterName, x, length);
	}

	public void setAsciiStream(String parameterName, InputStream x)
			throws SQLException {
		wrapped.setAsciiStream(parameterName, x);
	}

	public void setBigDecimal(int parameterIndex, BigDecimal x)
			throws SQLException {
		wrapped.setBigDecimal(parameterIndex, x);
	}

	public void setBigDecimal(String parameterName, BigDecimal x)
			throws SQLException {
		wrapped.setBigDecimal(parameterName, x);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		wrapped.setBinaryStream(parameterIndex, x, length);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		wrapped.setBinaryStream(parameterIndex, x, length);
	}

	public void setBinaryStream(int parameterIndex, InputStream x)
			throws SQLException {
		wrapped.setBinaryStream(parameterIndex, x);
	}

	public void setBinaryStream(String parameterName, InputStream x, int length)
			throws SQLException {
		wrapped.setBinaryStream(parameterName, x, length);
	}

	public void setBinaryStream(String parameterName, InputStream x, long length)
			throws SQLException {
		wrapped.setBinaryStream(parameterName, x, length);
	}

	public void setBinaryStream(String parameterName, InputStream x)
			throws SQLException {
		wrapped.setBinaryStream(parameterName, x);
	}

	public void setBlob(int parameterIndex, Blob x) throws SQLException {
		wrapped.setBlob(parameterIndex, x);
	}

	public void setBlob(int parameterIndex, InputStream inputStream, long length)
			throws SQLException {
		wrapped.setBlob(parameterIndex, inputStream, length);
	}

	public void setBlob(int parameterIndex, InputStream inputStream)
			throws SQLException {
		wrapped.setBlob(parameterIndex, inputStream);
	}

	public void setBlob(String parameterName, Blob x) throws SQLException {
		wrapped.setBlob(parameterName, x);
	}

	public void setBlob(String parameterName, InputStream inputStream,
			long length) throws SQLException {
		wrapped.setBlob(parameterName, inputStream, length);
	}

	public void setBlob(String parameterName, InputStream inputStream)
			throws SQLException {
		wrapped.setBlob(parameterName, inputStream);
	}

	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		wrapped.setBoolean(parameterIndex, x);
	}

	public void setBoolean(String parameterName, boolean x) throws SQLException {
		wrapped.setBoolean(parameterName, x);
	}

	public void setByte(int parameterIndex, byte x) throws SQLException {
		wrapped.setByte(parameterIndex, x);
	}

	public void setByte(String parameterName, byte x) throws SQLException {
		wrapped.setByte(parameterName, x);
	}

	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		wrapped.setBytes(parameterIndex, x);
	}

	public void setBytes(String parameterName, byte[] x) throws SQLException {
		wrapped.setBytes(parameterName, x);
	}

	public void setCharacterStream(int parameterIndex, Reader reader, int length)
			throws SQLException {
		wrapped.setCharacterStream(parameterIndex, reader, length);
	}

	public void setCharacterStream(int parameterIndex, Reader reader,
			long length) throws SQLException {
		wrapped.setCharacterStream(parameterIndex, reader, length);
	}

	public void setCharacterStream(int parameterIndex, Reader reader)
			throws SQLException {
		wrapped.setCharacterStream(parameterIndex, reader);
	}

	public void setCharacterStream(String parameterName, Reader reader,
			int length) throws SQLException {
		wrapped.setCharacterStream(parameterName, reader, length);
	}

	public void setCharacterStream(String parameterName, Reader reader,
			long length) throws SQLException {
		wrapped.setCharacterStream(parameterName, reader, length);
	}

	public void setCharacterStream(String parameterName, Reader reader)
			throws SQLException {
		wrapped.setCharacterStream(parameterName, reader);
	}

	public void setClob(int parameterIndex, Clob x) throws SQLException {
		wrapped.setClob(parameterIndex, x);
	}

	public void setClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		wrapped.setClob(parameterIndex, reader, length);
	}

	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		wrapped.setClob(parameterIndex, reader);
	}

	public void setClob(String parameterName, Clob x) throws SQLException {
		wrapped.setClob(parameterName, x);
	}

	public void setClob(String parameterName, Reader reader, long length)
			throws SQLException {
		wrapped.setClob(parameterName, reader, length);
	}

	public void setClob(String parameterName, Reader reader)
			throws SQLException {
		wrapped.setClob(parameterName, reader);
	}

	public void setCursorName(String name) throws SQLException {
		wrapped.setCursorName(name);
	}

	public void setDate(int parameterIndex, Date x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setDate(parameterIndex, x);
		} else {
			wrapped.setDate(parameterIndex, x, cal);
		}
	}

	public void setDate(int parameterIndex, Date x) throws SQLException {
		wrapped.setDate(parameterIndex, x);
	}

	public void setDate(String parameterName, Date x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setDate(parameterName, x);
		} else {
			wrapped.setDate(parameterName, x, cal);
		}
	}

	public void setDate(String parameterName, Date x) throws SQLException {
		wrapped.setDate(parameterName, x);
	}

	public void setDouble(int parameterIndex, double x) throws SQLException {
		wrapped.setDouble(parameterIndex, x);
	}

	public void setDouble(String parameterName, double x) throws SQLException {
		wrapped.setDouble(parameterName, x);
	}

	public void setEscapeProcessing(boolean enable) throws SQLException {
		wrapped.setEscapeProcessing(enable);
	}

	public void setFetchDirection(int direction) throws SQLException {
		wrapped.setFetchDirection(direction);
	}

	public void setFetchSize(int rows) throws SQLException {
		wrapped.setFetchSize(rows);
	}

	public void setFloat(int parameterIndex, float x) throws SQLException {
		wrapped.setFloat(parameterIndex, x);
	}

	public void setFloat(String parameterName, float x) throws SQLException {
		wrapped.setFloat(parameterName, x);
	}

	public void setInt(int parameterIndex, int x) throws SQLException {
		wrapped.setInt(parameterIndex, x);
	}

	public void setInt(String parameterName, int x) throws SQLException {
		wrapped.setInt(parameterName, x);
	}

	public void setLong(int parameterIndex, long x) throws SQLException {
		wrapped.setLong(parameterIndex, x);
	}

	public void setLong(String parameterName, long x) throws SQLException {
		wrapped.setLong(parameterName, x);
	}

	public void setMaxFieldSize(int max) throws SQLException {
		wrapped.setMaxFieldSize(max);
	}

	public void setMaxRows(int max) throws SQLException {
		wrapped.setMaxRows(max);
	}

	public void setNCharacterStream(int parameterIndex, Reader value,
			long length) throws SQLException {
		wrapped.setNCharacterStream(parameterIndex, value, length);
	}

	public void setNCharacterStream(int parameterIndex, Reader value)
			throws SQLException {
		wrapped.setNCharacterStream(parameterIndex, value);
	}

	public void setNCharacterStream(String parameterName, Reader value,
			long length) throws SQLException {
		wrapped.setNCharacterStream(parameterName, value, length);
	}

	public void setNCharacterStream(String parameterName, Reader value)
			throws SQLException {
		wrapped.setNCharacterStream(parameterName, value);
	}

	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		wrapped.setNClob(parameterIndex, value);
	}

	public void setNClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		wrapped.setNClob(parameterIndex, reader, length);
	}

	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		wrapped.setNClob(parameterIndex, reader);
	}

	public void setNClob(String parameterName, NClob value) throws SQLException {
		wrapped.setNClob(parameterName, value);
	}

	public void setNClob(String parameterName, Reader reader, long length)
			throws SQLException {
		wrapped.setNClob(parameterName, reader, length);
	}

	public void setNClob(String parameterName, Reader reader)
			throws SQLException {
		wrapped.setNClob(parameterName, reader);
	}

	public void setNString(int parameterIndex, String value)
			throws SQLException {
		wrapped.setNString(parameterIndex, value);
	}

	public void setNString(String parameterName, String value)
			throws SQLException {
		wrapped.setNString(parameterName, value);
	}

	public void setNull(int parameterIndex, int sqlType, String typeName)
			throws SQLException {
		wrapped.setNull(parameterIndex, sqlType, typeName);
	}

	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		wrapped.setNull(parameterIndex, sqlType);
	}

	public void setNull(String parameterName, int sqlType, String typeName)
			throws SQLException {
		wrapped.setNull(parameterName, sqlType, typeName);
	}

	public void setNull(String parameterName, int sqlType) throws SQLException {
		wrapped.setNull(parameterName, sqlType);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType,
			int scaleOrLength) throws SQLException {
		wrapped.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
	}

	public void setObject(int parameterIndex, Object x, int targetSqlType)
			throws SQLException {
		wrapped.setObject(parameterIndex, x, targetSqlType);
	}

	public void setObject(int parameterIndex, Object x) throws SQLException {
		wrapped.setObject(parameterIndex, x);
	}

	public void setObject(String parameterName, Object x, int targetSqlType,
			int scale) throws SQLException {
		wrapped.setObject(parameterName, x, targetSqlType, scale);
	}

	public void setObject(String parameterName, Object x, int targetSqlType)
			throws SQLException {
		wrapped.setObject(parameterName, x, targetSqlType);
	}

	public void setObject(String parameterName, Object x) throws SQLException {
		wrapped.setObject(parameterName, x);
	}

	public void setPoolable(boolean poolable) throws SQLException {
		wrapped.setPoolable(poolable);
	}

	public void setQueryTimeout(int seconds) throws SQLException {
		wrapped.setQueryTimeout(seconds);
	}

	public void setRef(int parameterIndex, Ref x) throws SQLException {
		wrapped.setRef(parameterIndex, x);
	}

	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		wrapped.setRowId(parameterIndex, x);
	}

	public void setRowId(String parameterName, RowId x) throws SQLException {
		wrapped.setRowId(parameterName, x);
	}

	public void setShort(int parameterIndex, short x) throws SQLException {
		wrapped.setShort(parameterIndex, x);
	}

	public void setShort(String parameterName, short x) throws SQLException {
		wrapped.setShort(parameterName, x);
	}

	public void setSQLXML(int parameterIndex, SQLXML xmlObject)
			throws SQLException {
		wrapped.setSQLXML(parameterIndex, xmlObject);
	}

	public void setSQLXML(String parameterName, SQLXML xmlObject)
			throws SQLException {
		wrapped.setSQLXML(parameterName, xmlObject);
	}

	public void setString(int parameterIndex, String x) throws SQLException {
		wrapped.setString(parameterIndex, x);
	}

	public void setString(String parameterName, String x) throws SQLException {
		wrapped.setString(parameterName, x);
	}

	public void setTime(int parameterIndex, Time x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setTime(parameterIndex, x);
		} else {
			wrapped.setTime(parameterIndex, x, cal);
		}
	}

	public void setTime(int parameterIndex, Time x) throws SQLException {
		wrapped.setTime(parameterIndex, x);
	}

	public void setTime(String parameterName, Time x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setTime(parameterName, x);
		} else {
			wrapped.setTime(parameterName, x, cal);
		}
	}

	public void setTime(String parameterName, Time x) throws SQLException {
		wrapped.setTime(parameterName, x);
	}

	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setTimestamp(parameterIndex, x);
		} else {
			wrapped.setTimestamp(parameterIndex, x, cal);
		}
	}

	public void setTimestamp(int parameterIndex, Timestamp x)
			throws SQLException {
		wrapped.setTimestamp(parameterIndex, x);
	}

	public void setTimestamp(String parameterName, Timestamp x, Calendar cal)
			throws SQLException {
		//driverによってnullの場合の挙動が異なるので、ここで吸収。。
		if (cal == null) {
			wrapped.setTimestamp(parameterName, x);
		} else {
			wrapped.setTimestamp(parameterName, x, cal);
		}
	}

	public void setTimestamp(String parameterName, Timestamp x)
			throws SQLException {
		wrapped.setTimestamp(parameterName, x);
	}

	@SuppressWarnings("deprecation")
	public void setUnicodeStream(int parameterIndex, InputStream x, int length)
			throws SQLException {
		wrapped.setUnicodeStream(parameterIndex, x, length);
	}

	public void setURL(int parameterIndex, URL x) throws SQLException {
		wrapped.setURL(parameterIndex, x);
	}

	public void setURL(String parameterName, URL val) throws SQLException {
		wrapped.setURL(parameterName, val);
	}

	public <T> T unwrap(Class<T> iface) throws SQLException {
		return wrapped.unwrap(iface);
	}

	public boolean wasNull() throws SQLException {
		return wrapped.wasNull();
	}

	//for jdbc 4.1
	public void closeOnCompletion() throws SQLException {
		wrapped.closeOnCompletion();
	}

	public boolean isCloseOnCompletion() throws SQLException {
		return wrapped.isCloseOnCompletion();
	}

	public <T> T getObject(int parameterIndex, Class<T> type)
			throws SQLException {
		return wrapped.getObject(parameterIndex, type);
	}

	public <T> T getObject(String parameterName, Class<T> type)
			throws SQLException {
		return wrapped.getObject(parameterName, type);
	}
}
