/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.googlecloud;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import org.iplass.mtp.impl.googlecloud.GoogleCredentialsFactory;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class GoogleCloudSettings
implements Service {
    private GoogleCredentials googleCredentials;

    public void init(Config config) {
        GoogleCredentialsFactory credentialsFactory = (GoogleCredentialsFactory)config.getValue("credentialsFactory", GoogleCredentialsFactory.class);
        this.googleCredentials = credentialsFactory.create();
    }

    public void destroy() {
        this.googleCredentials = null;
    }

    public GoogleCredentials getCredentials() {
        return this.googleCredentials;
    }

    public String getAccessTokenValue() {
        try {
            this.googleCredentials.refreshIfExpired();
            return this.googleCredentials.getAccessToken().getTokenValue();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get access token.", e);
        }
    }
}

