/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.googlecloud;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.iplass.mtp.impl.googlecloud.GoogleCredentialsFactory;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class ServiceAccountSecretKeyGoogleCredentialsFactory
implements GoogleCredentialsFactory {
    private String serviceAccountSecretKeyFilePath;
    private String[] scope;
    private String proxyHost;
    private Integer proxyPort;

    public String getServiceAccountSecretKeyFilePath() {
        return this.serviceAccountSecretKeyFilePath;
    }

    public void setServiceAccountSecretKeyFilePath(String serviceAccountSecretKeyFilePath) {
        this.serviceAccountSecretKeyFilePath = serviceAccountSecretKeyFilePath;
    }

    public String[] getScope() {
        return this.scope;
    }

    public void setScope(String[] scope) {
        this.scope = scope;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public GoogleCredentials create() {
        GoogleCredentials googleCredentials;
        block9: {
            InputStream sercretKeyFile = this.getFileOrResource(this.serviceAccountSecretKeyFilePath);
            try {
                GoogleCredentials googleCredentials2 = null == this.proxyHost ? GoogleCredentials.fromStream((InputStream)sercretKeyFile) : GoogleCredentials.fromStream((InputStream)sercretKeyFile, () -> {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
                    return new NetHttpTransport.Builder().setProxy(proxy).build();
                });
                GoogleCredentials googleCredentials3 = googleCredentials = null == this.scope ? googleCredentials2 : googleCredentials2.createScoped(this.scope);
                if (sercretKeyFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sercretKeyFile != null) {
                        try {
                            sercretKeyFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new ServiceConfigrationException("Service account secret key file not found. Please fix the service-config settings.", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ServiceConfigrationException("Failed to generate Google credentials.", (Throwable)e);
                }
            }
            sercretKeyFile.close();
        }
        return googleCredentials;
    }

    private InputStream getFileOrResource(String path) throws FileNotFoundException {
        InputStream resource = ServiceAccountSecretKeyGoogleCredentialsFactory.class.getResourceAsStream(path);
        if (null != resource) {
            return resource;
        }
        return new BufferedInputStream(new FileInputStream(path));
    }
}

