/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification.fcm;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.pushnotification.PushNotificationService;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationException;
import org.iplass.mtp.pushnotification.PushNotificationResult;
import org.iplass.mtp.pushnotification.fcm.RegistrationIdHandler;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FCMPushNotificationService
extends PushNotificationService {
    private static Logger logger = LoggerFactory.getLogger(FCMPushNotificationService.class);
    private String authorizationKey;
    private boolean dryRun;
    private boolean enableRetry = true;
    private RegistrationIdHandler registrationIdHandler;
    private ExponentialBackoff exponentialBackoff;
    private HttpClientConfig httpClientConfig;
    private String endpoint = "https://fcm.googleapis.com/fcm/send";
    private ObjectMapper jsonMapper;
    private Pattern conditionPattern = Pattern.compile(".*in\\s*topics.*", 2);

    public void init(Config config) {
        super.init(config);
        this.authorizationKey = config.getValue("authorizationKey");
        if (config.getValue("dryRun") != null) {
            this.dryRun = Boolean.valueOf(config.getValue("dryRun"));
        }
        if (config.getValue("enableRetry") != null) {
            this.enableRetry = Boolean.valueOf(config.getValue("enableRetry"));
        }
        if (this.enableRetry) {
            this.exponentialBackoff = (ExponentialBackoff)config.getValue("exponentialBackoff", ExponentialBackoff.class);
            if (this.exponentialBackoff == null) {
                this.exponentialBackoff = new ExponentialBackoff();
            }
        } else {
            this.exponentialBackoff = ExponentialBackoff.NO_RETRY;
        }
        this.registrationIdHandler = (RegistrationIdHandler)config.getValue("registrationIdHandler", RegistrationIdHandler.class);
        this.httpClientConfig = (HttpClientConfig)config.getValue("httpClientConfig", HttpClientConfig.class);
        if (this.httpClientConfig == null) {
            this.httpClientConfig = new HttpClientConfig();
            this.httpClientConfig.inited((Service)this, config);
        }
        if (config.getValue("endpoint") != null) {
            this.endpoint = config.getValue("endpoint");
        }
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.jsonMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }

    public void destroy() {
        this.jsonMapper = null;
        super.destroy();
    }

    protected PushNotificationResult pushImpl(Tenant tenant, PushNotification notification) {
        try {
            boolean isMulti = notification.getToList().size() > 1;
            long endTime = System.currentTimeMillis() + this.exponentialBackoff.getMaxElapsedTimeMillis();
            PushNotificationResult result = new PushNotificationResult();
            long[] retryAfter = new long[]{-1L};
            this.exponentialBackoff.execute(() -> {
                long currentTime = System.currentTimeMillis();
                if (retryAfter[0] > currentTime) {
                    if (retryAfter[0] > endTime) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("execution failed cause retryAfter Header value is over maxElapsedTimeMillis.");
                        }
                        result.setDetail("retryAfter", (Object)new Date(retryAfter[0]));
                        return true;
                    }
                    try {
                        Thread.sleep(retryAfter[0] - currentTime);
                    }
                    catch (Exception e) {
                        throw new PushNotificationException("FCM call thread is Interrupted.", (Throwable)e);
                    }
                }
                try {
                    if (isMulti) {
                        return this.multiRegistrationIdCall(notification, result, retryAfter);
                    }
                    return this.simpleCall(notification, result, retryAfter);
                }
                catch (IOException | ParseException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("can not access FCM... cause:" + e.getMessage(), e);
                    }
                    result.setDetail("lastException", (Object)e);
                    return false;
                }
            });
            return result;
        }
        catch (InterruptedException e) {
            throw new PushNotificationException("FCM call thread is Interrupted.", (Throwable)e);
        }
    }

    private long parseRetryAfter(HttpResponse res) {
        Header header = res.getFirstHeader("Retry-After");
        if (header == null) {
            return -1L;
        }
        String val = header.getValue();
        if (val == null) {
            return -1L;
        }
        try {
            long valLong = Long.parseLong(val);
            return System.currentTimeMillis() + valLong * 1000L;
        }
        catch (NumberFormatException valLong) {
            Date d = DateUtils.parseDate((String)val);
            if (d == null) {
                return -1L;
            }
            return d.getTime();
        }
    }

    private ResultType handleResult(Map<String, Object> res, String regId) {
        String newRegId;
        String error = (String)res.get("error");
        if (error != null) {
            if (error.equals("NotRegistered") && this.registrationIdHandler != null && regId != null) {
                this.registrationIdHandler.removeRegistrationId(regId);
            }
            if (this.isRetryableError(error)) {
                return ResultType.RETRY;
            }
            return ResultType.ERROR;
        }
        if (this.registrationIdHandler != null && regId != null && (newRegId = (String)res.get("registration_id")) != null) {
            this.registrationIdHandler.refreshRegistrationId(regId, newRegId);
        }
        return ResultType.SUCCESS;
    }

    private boolean isRetryableError(String error) {
        switch (error) {
            case "Unavailable": 
            case "InternalServerError": {
                return true;
            }
        }
        return false;
    }

    private int sendMsg(PushNotification notification, ResHandler resHandler) throws ParseException, IOException {
        String jsonMsg = this.toJson(notification);
        if (logger.isDebugEnabled()) {
            logger.debug("call FCM whith message:" + jsonMsg);
        }
        CloseableHttpClient client = this.httpClientConfig.getInstance();
        HttpPost post = new HttpPost(this.endpoint);
        post.setHeader("Authorization", (Object)("key=" + this.authorizationKey));
        post.setHeader("Content-Type", (Object)"application/json");
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, StandardCharsets.UTF_8));
        return (Integer)client.execute((ClassicHttpRequest)post, response -> {
            try {
                int status = response.getCode();
                if (401 == status) {
                    throw new PushNotificationException("can not auth.");
                }
                if (status == 400) {
                    if (logger.isDebugEnabled()) {
                        ClassicHttpResponse cres;
                        logger.debug("{} {} {}", new Object[]{response.getVersion(), response.getCode(), response.getReasonPhrase()});
                        if (response.getHeaders() != null) {
                            for (Header h : response.getHeaders()) {
                                logger.debug(h.toString());
                            }
                        }
                        if (response instanceof ClassicHttpResponse && (cres = response).getEntity() != null) {
                            logger.debug(EntityUtils.toString((HttpEntity)cres.getEntity(), (Charset)StandardCharsets.UTF_8));
                        }
                    }
                    throw new PushNotificationException("invalid json message:" + jsonMsg);
                }
                if ((status < 500 || status >= 600) && status != 200) {
                    throw new PushNotificationException("FCM return unknown status:" + status);
                }
                resHandler.handle(response);
                Integer n = status;
                return n;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        });
    }

    private String toJson(PushNotification notification) {
        try {
            return this.jsonMapper.writeValueAsString(this.toMessageMap(notification));
        }
        catch (JsonProcessingException e) {
            throw new PushNotificationException("can not serialize to json", (Throwable)e);
        }
    }

    private boolean simpleCall(PushNotification notification, PushNotificationResult result, long[] retryAfter) throws ParseException, IOException {
        String[] content = new String[]{null};
        int status = this.sendMsg(notification, res -> {
            retryAfter[0] = this.parseRetryAfter((HttpResponse)res);
            HttpEntity entity = res.getEntity();
            if (entity != null) {
                content[0] = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("FCM response:status=" + status + ", content=" + content[0]);
        }
        if (status >= 500) {
            return false;
        }
        Map cmap = (Map)this.jsonMapper.readValue(content[0], Map.class);
        result.setDetails(cmap);
        ResultType rt = cmap.get("message_id") != null ? this.handleResult(cmap, null) : this.handleResult((Map)((List)cmap.get("results")).get(0), (String)notification.getToList().get(0));
        switch (rt.ordinal()) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 0: {
                result.setSuccess(true);
                return true;
            }
        }
        return false;
    }

    private boolean multiRegistrationIdCall(PushNotification notification, PushNotificationResult result, long[] retryAfter) throws ParseException, IOException {
        List orgResults = (List)result.getDetail("results");
        ArrayList<Integer> indexMap = null;
        ArrayList<String> ids = notification.getToList();
        PushNotification ntf = notification;
        if (orgResults != null) {
            indexMap = new ArrayList<Integer>();
            ids = new ArrayList<String>();
            List orgList = notification.getToList();
            for (int i = 0; i < orgList.size(); ++i) {
                String error = (String)((Map)orgResults.get(i)).get("error");
                if (error == null || !this.isRetryableError(error)) continue;
                indexMap.add(i);
                ids.add((String)orgList.get(i));
            }
            ntf = new PushNotification();
            ntf.setToList(ids);
            ntf.setData(notification.getData());
            ntf.setNotification(notification.getNotification());
            ntf.setOptions(notification.getOptions());
        }
        String[] content = new String[]{null};
        int status = this.sendMsg(ntf, res -> {
            retryAfter[0] = this.parseRetryAfter((HttpResponse)res);
            HttpEntity entity = res.getEntity();
            if (entity != null) {
                content[0] = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("FCM response:status=" + status + ", content=" + content[0]);
        }
        if (status >= 500) {
            return false;
        }
        Map cmap = (Map)this.jsonMapper.readValue(content[0], Map.class);
        List rs = (List)cmap.get("results");
        boolean needRetry = false;
        for (int i = 0; i < ids.size(); ++i) {
            ResultType rt = this.handleResult((Map)rs.get(i), (String)ids.get(i));
            if (rt != ResultType.RETRY) continue;
            needRetry = true;
        }
        if (orgResults == null) {
            result.setDetails(cmap);
            orgResults = rs;
        } else {
            int totalSuccessCount = ((Number)result.getDetail("success")).intValue();
            int totalFailureCount = ((Number)result.getDetail("failure")).intValue();
            int totalCanonicalIdsCount = ((Number)result.getDetail("canonical_ids")).intValue();
            int successCount = ((Number)cmap.get("success")).intValue();
            int canonicalIdsCount = ((Number)cmap.get("canonical_ids")).intValue();
            result.setDetail("success", (Object)(totalSuccessCount += successCount));
            result.setDetail("failure", (Object)(totalFailureCount -= successCount));
            result.setDetail("canonical_ids", (Object)(totalCanonicalIdsCount += canonicalIdsCount));
            for (int i = 0; i < ids.size(); ++i) {
                orgResults.set((Integer)indexMap.get(i), (Map)rs.get(i));
            }
        }
        if (needRetry) {
            return false;
        }
        boolean hasError = false;
        for (int i = 0; i < orgResults.size(); ++i) {
            String error = (String)((Map)orgResults.get(i)).get("error");
            if (error == null) continue;
            hasError = true;
            break;
        }
        if (!hasError) {
            result.setSuccess(true);
        }
        return true;
    }

    private Map<String, Object> toMessageMap(PushNotification notification) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List toList = notification.getToList();
        if (toList.size() == 0) {
            throw new PushNotificationException("To list not specified.");
        }
        if (toList.size() == 1) {
            if (this.conditionPattern.matcher((CharSequence)toList.get(0)).matches()) {
                map.put("condition", toList.get(0));
            } else {
                map.put("to", toList.get(0));
            }
        } else {
            map.put("registration_ids", toList);
        }
        if (notification.getOptions() != null) {
            map.putAll(notification.getOptions());
        }
        if (notification.getData() != null && notification.getData().size() > 0) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (String key : notification.getData().keySet()) {
                dataMap.put(key, notification.getData().get(key));
            }
            map.put("data", dataMap);
        }
        if (notification.getNotification() != null && notification.getNotification().size() > 0) {
            HashMap<String, Object> notificationMap = new HashMap<String, Object>();
            for (String key : notification.getNotification().keySet()) {
                notificationMap.put(key, notification.getNotification().get(key));
            }
            map.put("notification", notificationMap);
        }
        if (this.dryRun) {
            map.put("dry_run", true);
        }
        return map;
    }

    private static enum ResultType {
        SUCCESS,
        RETRY,
        ERROR;

    }

    static interface ResHandler {
        public void handle(ClassicHttpResponse var1) throws ParseException, IOException;
    }
}

