/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification.fcmv1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.iplass.mtp.impl.googlecloud.GoogleCloudSettings;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.pushnotification.fcmv1.EmptyRegistrationTokenHandler;
import org.iplass.mtp.pushnotification.NotificationPayload;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationException;
import org.iplass.mtp.pushnotification.PushNotificationResult;
import org.iplass.mtp.pushnotification.fcmv1.PushNotificationResponseDetail;
import org.iplass.mtp.pushnotification.fcmv1.PushNotificationStatus;
import org.iplass.mtp.pushnotification.fcmv1.PushNotificationTarget;
import org.iplass.mtp.pushnotification.fcmv1.PushNotificationTargetType;
import org.iplass.mtp.pushnotification.fcmv1.RegistrationTokenHandler;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushNotificationService
extends org.iplass.mtp.impl.pushnotification.PushNotificationService {
    private static final String SERVICE_ENDPOINT_PREFIX = "https://fcm.googleapis.com/v1/projects/";
    private static final String SERVICE_ENDPOINT_POSTFIX = "/messages:send";
    private static final String RESPONSE_HEADER_RETRY_AFTER = "retry-after";
    private static final long DEFAULT_RETRY_AFTER_SECONDS = 60L;
    private static final boolean DEFAULT_ENABLE_RETRY = true;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+$");
    private Set<Integer> retryableStatusSet = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(429, 503, 500)));
    private Logger logger = LoggerFactory.getLogger(PushNotificationService.class);
    private String serviceEndpoint;
    private GoogleCloudSettings googleCloudSettings;
    private Function<HttpEntity, HttpEntity> compressRequestEntity;
    private PushApiRequestFunction pushApi;
    private String projectId;
    private Boolean compressRequest;
    private Boolean apiRequestValidateOnly;
    private Boolean enableRetry;
    private ExponentialBackoff exponentialBackoff;
    private Long defaultRetryAfterSeconds;
    private RegistrationTokenHandler registrationTokenHandler;
    private ObjectMapper objectMapper;
    private HttpClientConfig httpClientConfig;

    public void init(Config config) {
        super.init(config);
        this.projectId = config.getValue("projectId");
        this.compressRequest = (Boolean)config.getValue("compressRequest", Boolean.class, (Object)Boolean.TRUE);
        this.apiRequestValidateOnly = (Boolean)config.getValue("apiRequestValidateOnly", Boolean.class, (Object)Boolean.FALSE);
        this.enableRetry = (Boolean)config.getValue("enableRetry", Boolean.class, (Object)true);
        this.exponentialBackoff = this.enableRetry != false ? (ExponentialBackoff)config.getValue("exponentialBackoff", ExponentialBackoff.class, (Object)new ExponentialBackoff()) : ExponentialBackoff.NO_RETRY;
        this.defaultRetryAfterSeconds = (long)((Long)config.getValue("defaultRetryAfterSeconds", Long.class, (Object)60L));
        this.registrationTokenHandler = (RegistrationTokenHandler)config.getValue("registrationTokenHandler", RegistrationTokenHandler.class, (Object)new EmptyRegistrationTokenHandler());
        this.httpClientConfig = (HttpClientConfig)config.getValueWithSupplier("httpClientConfig", HttpClientConfig.class, () -> new HttpClientConfig());
        this.objectMapper = (ObjectMapper)config.getValueWithSupplier("objectMapper", ObjectMapper.class, () -> ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS}).withConfigOverride(Map.class, c -> c.setInclude(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL)))).build());
        if (StringUtil.isEmpty((String)this.projectId)) {
            throw new ServiceConfigrationException("Service property 'projectId' is not set. Please fix the service-config settings.");
        }
        this.serviceEndpoint = SERVICE_ENDPOINT_PREFIX + this.projectId + SERVICE_ENDPOINT_POSTFIX;
        this.googleCloudSettings = (GoogleCloudSettings)ServiceRegistry.getRegistry().getService(GoogleCloudSettings.class);
        this.compressRequestEntity = this.compressRequest != false ? this::compressHttpEntity : this::plainHttpEntity;
        this.pushApi = this.enableRetry != false ? this::requestPushApiExponentialBackoff : this::requestPushApi;
    }

    public void destroy() {
    }

    protected PushNotificationResult pushImpl(Tenant tenant, PushNotification notification) {
        boolean toListIsNotEmpty = 0 < notification.getToList().size();
        return toListIsNotEmpty ? this.pushByToList(tenant, notification) : this.pushByMessage(tenant, notification);
    }

    private PushNotificationResult pushByToList(Tenant tenant, PushNotification notification) {
        Map<String, Object> message = this.toMessageResource(notification);
        PushNotificationTarget target = this.getTarget(message);
        if (null != target) {
            message.remove(target.getType().getFieldName());
            this.logger.warn("A destination({}:{}) was set but is ignored, because it is the destination set for the message.", (Object)target.getType(), (Object)target.getTarget());
        }
        ArrayList<PushNotificationResponseDetail> responseDetailList = new ArrayList<PushNotificationResponseDetail>();
        for (String prefixedTo : notification.getToList()) {
            HashMap<String, Object> messageClone = new HashMap<String, Object>(message);
            PushNotificationTarget toTarget = PushNotificationTarget.create(prefixedTo);
            messageClone.put(toTarget.getType().getFieldName(), toTarget.getTarget());
            PushNotificationResponseDetail responseDetail = this.pushApi.request(toTarget, messageClone);
            responseDetailList.add(responseDetail);
        }
        HashMap<String, ArrayList<PushNotificationResponseDetail>> detail = new HashMap<String, ArrayList<PushNotificationResponseDetail>>();
        detail.put("detailList", responseDetailList);
        boolean isSuccessAll = responseDetailList.stream().filter(r -> PushNotificationStatus.SUCCESS != r.getStatus()).count() == 0L;
        return new PushNotificationResult(isSuccessAll, detail);
    }

    private PushNotificationResult pushByMessage(Tenant tenant, PushNotification notification) {
        Map<String, Object> message = this.toMessageResource(notification);
        PushNotificationTarget target = this.getTarget(message);
        if (null == target) {
            throw new PushNotificationException("Notification target information is not set. Please set " + PushNotificationTargetType.TOKEN.getFieldName() + " or " + PushNotificationTargetType.TOPIC.getFieldName() + " or " + PushNotificationTargetType.CONDITION.getFieldName() + ".");
        }
        ArrayList<PushNotificationResponseDetail> responseDetailList = new ArrayList<PushNotificationResponseDetail>();
        PushNotificationResponseDetail responseDetail = this.pushApi.request(target, message);
        responseDetailList.add(responseDetail);
        HashMap<String, ArrayList<PushNotificationResponseDetail>> detail = new HashMap<String, ArrayList<PushNotificationResponseDetail>>();
        detail.put("detailList", responseDetailList);
        boolean isSuccessAll = responseDetailList.stream().filter(r -> PushNotificationStatus.SUCCESS != r.getStatus()).count() == 0L;
        return new PushNotificationResult(isSuccessAll, detail);
    }

    protected PushNotificationResponseDetail requestPushApiExponentialBackoff(PushNotificationTarget target, Map<String, Object> messageResource) {
        try {
            PushNotificationResponseDetail[] result = new PushNotificationResponseDetail[]{null};
            ZonedDateTime maxElapsedDateTime = ZonedDateTime.now().plus(Duration.ofMillis(this.exponentialBackoff.getMaxElapsedTimeMillis()));
            int[] retryCount = new int[]{-1};
            this.exponentialBackoff.execute(() -> {
                PushNotificationResponseDetail responseDetail;
                retryCount[0] = retryCount[0] + 1;
                result[0] = responseDetail = this.requestPushApi(target, messageResource);
                if (PushNotificationStatus.FAIL_RETRYABLE == responseDetail.getStatus()) {
                    ZonedDateTime waitFinishDateTime = ZonedDateTime.now().plus(Duration.ofSeconds(responseDetail.getRetryAfterSeconds()));
                    if (maxElapsedDateTime.isAfter(waitFinishDateTime)) {
                        try {
                            Thread.sleep(Duration.ofSeconds(responseDetail.getRetryAfterSeconds()));
                        }
                        catch (InterruptedException e) {
                            throw new PushNotificationException("FCM v1 API call thread is Interrupted.", (Throwable)e);
                        }
                        return false;
                    }
                    this.logger.warn("Retryable error, but aborted because the maximum elapsed time has passed. target = {}:{}.", (Object)responseDetail.getTarget().getType(), (Object)responseDetail.getTarget().getTarget());
                }
                return true;
            });
            PushNotificationResponseDetail detail = result[0];
            detail.setRetryCount(retryCount[0]);
            return detail;
        }
        catch (InterruptedException e) {
            throw new PushNotificationException("FCM v1 API call thread is Interrupted.", (Throwable)e);
        }
    }

    protected PushNotificationResponseDetail requestPushApi(PushNotificationTarget target, Map<String, Object> messageResource) {
        HttpPost request = new HttpPost(this.serviceEndpoint);
        request.setHeader("Authorization", (Object)("Bearer " + this.googleCloudSettings.getAccessTokenValue()));
        Map<String, Object> requestBodyMap = this.toRequestBody(messageResource);
        try {
            String requestBody = this.objectMapper.writeValueAsString(requestBodyMap);
            HttpEntity requestEntity = this.compressRequestEntity.apply((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
            request.setEntity(requestEntity);
            this.logger.debug("Request - requestBody = {}, headers = {}", (Object)requestBody, (Object)request.getHeaders());
            PushNotificationResponseDetail responseDetail = (PushNotificationResponseDetail)this.httpClientConfig.getInstance().execute((ClassicHttpRequest)request, response -> {
                HttpEntity entity = response.getEntity();
                try {
                    String contents = EntityUtils.toString((HttpEntity)entity);
                    this.logger.debug("Response - serviceEndpoint = {}, code = {}({}), contents = {}, headers = {}", new Object[]{this.serviceEndpoint, response.getCode(), response.getReasonPhrase(), contents, response.getHeaders()});
                    Header retryAfterHeader = response.getFirstHeader(RESPONSE_HEADER_RETRY_AFTER);
                    String retryAfterValue = null != retryAfterHeader ? retryAfterHeader.getValue() : null;
                    long retryAfterSeconds = this.toRetryAfterSeconds(retryAfterValue, this.defaultRetryAfterSeconds);
                    PushNotificationResponseDetail pushNotificationResponseDetail = this.handleResponse(target, response.getCode(), contents, retryAfterSeconds);
                    return pushNotificationResponseDetail;
                }
                finally {
                    EntityUtils.consume((HttpEntity)entity);
                }
            });
            this.postProcessOfReequestPushApi(responseDetail);
            return responseDetail;
        }
        catch (SocketTimeoutException | ConnectionRequestTimeoutException e) {
            PushNotificationResponseDetail timeoutDetail = new PushNotificationResponseDetail(PushNotificationStatus.FAIL_TIMEOUT);
            timeoutDetail.setErrorMessage(e.getMessage());
            timeoutDetail.setCause(e);
            timeoutDetail.setTarget(target);
            return timeoutDetail;
        }
        catch (IOException e) {
            PushNotificationResponseDetail failDetail = new PushNotificationResponseDetail(PushNotificationStatus.FAIL);
            failDetail.setErrorMessage(e.getMessage());
            failDetail.setCause(e);
            failDetail.setTarget(target);
            return failDetail;
        }
    }

    protected PushNotificationResponseDetail handleResponse(PushNotificationTarget target, int code, String response, long retryAfterSeconds) throws IOException {
        Map contentsMap = (Map)this.objectMapper.readValue(response, Map.class);
        if (200 == code) {
            PushNotificationResponseDetail successDetail = new PushNotificationResponseDetail(PushNotificationStatus.SUCCESS);
            successDetail.setTarget(target);
            successDetail.setResponse(response);
            successDetail.setMessageId((String)contentsMap.get("name"));
            return successDetail;
        }
        Object error = contentsMap.get("error");
        if (error instanceof String) {
            PushNotificationResponseDetail failDetail = new PushNotificationResponseDetail(PushNotificationStatus.FAIL);
            failDetail.setTarget(target);
            failDetail.setResponse(response);
            failDetail.setErrorMessage((String)error);
            return failDetail;
        }
        Map errorMap = (Map)error;
        String errorMessage = (String)errorMap.get("message");
        if (this.retryableStatusSet.contains(code)) {
            PushNotificationResponseDetail retryableDetail = new PushNotificationResponseDetail(PushNotificationStatus.FAIL_RETRYABLE);
            retryableDetail.setTarget(target);
            retryableDetail.setResponse(response);
            retryableDetail.setErrorMessage(errorMessage);
            retryableDetail.setRetryAfterSeconds(retryAfterSeconds);
            return retryableDetail;
        }
        PushNotificationStatus status = PushNotificationStatus.FAIL;
        Object errorDetails = errorMap.get("details");
        if (null != errorDetails && errorDetails instanceof List) {
            List errorDetailsList = (List)errorDetails;
            for (Object detail : errorDetailsList) {
                Map detailMap;
                if (!(detail instanceof Map) || !"type.googleapis.com/google.firebase.fcm.v1.FcmError".equals((detailMap = (Map)detail).get("@type")) || !"UNREGISTERED".equals(detailMap.get("errorCode"))) continue;
                status = PushNotificationStatus.FAIL_DEVICE_UNREGISTERED;
                break;
            }
        }
        PushNotificationResponseDetail failOrDeviceUnregisteredDetail = new PushNotificationResponseDetail(status);
        failOrDeviceUnregisteredDetail.setTarget(target);
        failOrDeviceUnregisteredDetail.setResponse(response);
        failOrDeviceUnregisteredDetail.setErrorMessage(errorMessage);
        return failOrDeviceUnregisteredDetail;
    }

    protected void postProcessOfReequestPushApi(PushNotificationResponseDetail responseDetail) {
        if (PushNotificationTargetType.TOKEN == responseDetail.getTarget().getType() && PushNotificationStatus.FAIL_DEVICE_UNREGISTERED == responseDetail.getStatus()) {
            this.registrationTokenHandler.unregistered(responseDetail.getTarget());
        }
    }

    private PushNotificationTarget getTarget(Map<String, Object> message) {
        for (PushNotificationTargetType type : PushNotificationTargetType.values()) {
            String v = (String)message.get(type.getFieldName());
            if (null == v) continue;
            return new PushNotificationTarget(type, v);
        }
        return null;
    }

    private long toRetryAfterSeconds(String retryAfter, long defaultSeconds) {
        ZonedDateTime retryAfterDate;
        if (null == retryAfter || 0 == retryAfter.length()) {
            return defaultSeconds;
        }
        boolean isNumber = NUMBER_PATTERN.matcher(retryAfter).matches();
        if (isNumber) {
            return Long.valueOf(retryAfter);
        }
        ZonedDateTime now = ZonedDateTime.now();
        long retryAfterSeconds = Duration.between(now, retryAfterDate = DateUtils.parseStandardDate((String)retryAfter).atZone(ZoneId.systemDefault())).toSeconds();
        return 0L <= retryAfterSeconds ? retryAfterSeconds : 0L;
    }

    private Map<String, Object> toRequestBody(Map<String, Object> messageResource) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.apiRequestValidateOnly.booleanValue()) {
            data.put("validate_only", true);
        }
        data.put("message", messageResource);
        return data;
    }

    private Map<String, Object> toMessageResource(PushNotification notification) {
        HashMap<String, Object> message = notification.getMessage() == null ? new HashMap<String, Object>() : new HashMap(notification.getMessage());
        this.ifNotNullPutAll(message, "data", (Map<String, Object>)notification.getData());
        this.ifNotNullPutAll(message, "fcm_options", notification.getOptions());
        NotificationPayload notificationPayload = notification.getNotification();
        if (notificationPayload.containsKey((Object)"icon")) {
            HashMap<String, Object> copyPayload = new HashMap<String, Object>((Map<String, Object>)notificationPayload);
            copyPayload.remove("icon");
            this.ifNotNullPutAll(message, "notification", copyPayload);
            HashMap<String, Object> android = new HashMap<String, Object>();
            android.put("notification", notificationPayload);
            this.ifNotNullPutAll(message, "android", android);
        } else {
            this.ifNotNullPutAll(message, "notification", (Map<String, Object>)notificationPayload);
        }
        return message;
    }

    private void ifNotNullPutAll(Map<String, Object> map, String key, Map<String, Object> valueMap) {
        if (null != valueMap && !valueMap.isEmpty()) {
            HashMap child = map.get(key);
            if (null == child) {
                child = new HashMap();
                map.put(key, child);
            }
            if (child instanceof Map) {
                Map childMap = child;
                childMap.putAll(valueMap);
            } else {
                this.logger.warn("The instance set to the key '{}' is not a java.util.Map. (Class of value set: '{}')", (Object)key, (Object)child.getClass().getName());
            }
        }
    }

    private HttpEntity plainHttpEntity(HttpEntity entity) {
        return entity;
    }

    private HttpEntity compressHttpEntity(HttpEntity entity) {
        return new GzipCompressingEntity(entity);
    }

    @FunctionalInterface
    private static interface PushApiRequestFunction {
        public PushNotificationResponseDetail request(PushNotificationTarget var1, Map<String, Object> var2);
    }

    private static class Keys {
        private Keys() {
        }

        private static class Fail {
            private static final String ERROR = "error";
            private static final String ERROR_MESSAGE = "message";
            private static final String ERROR_DETAILS = "details";
            private static final String ERROR_DETAILS_TYPE = "@type";
            private static final String ERROR_DETAILS_ERROR_CODE = "errorCode";

            private Fail() {
            }
        }

        private static class Success {
            private static final String NAME = "name";

            private Success() {
            }
        }
    }

    private static class ErrorDetailsType {
        private static final String FCM_ERROR = "type.googleapis.com/google.firebase.fcm.v1.FcmError";

        private ErrorDetailsType() {
        }
    }

    private static class ErrorDetailsErrorCode {
        private static final String UNREGISTERED = "UNREGISTERED";

        private ErrorDetailsErrorCode() {
        }
    }
}

