/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.pushnotification.fcmv1;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.iplass.mtp.pushnotification.fcmv1.PushNotificationTargetType;

public class PushNotificationTarget {
    private PushNotificationTargetType type;
    private String target;
    private static final Pattern ANY_PREFIXED_VALUE_PATTERN = Pattern.compile("^(" + PushNotificationTargetType.TOKEN.getFieldName() + "|" + PushNotificationTargetType.TOPIC.getFieldName() + "|" + PushNotificationTargetType.CONDITION.getFieldName() + "):(.*)");

    public PushNotificationTarget(PushNotificationTargetType type, String target) {
        this.type = type;
        this.target = target;
    }

    public PushNotificationTargetType getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        return PushNotificationTarget.class.getSimpleName() + "{type=" + String.valueOf((Object)this.type) + ", target=" + this.target + "}";
    }

    public static PushNotificationTarget create(String anyPrefixedValue) {
        Matcher matcher = ANY_PREFIXED_VALUE_PATTERN.matcher(anyPrefixedValue);
        if (!matcher.find()) {
            throw new IllegalArgumentException("The target specified does not match the pattern. (target = " + anyPrefixedValue + ")");
        }
        String prefixIsFieldName = matcher.group(1);
        String target = matcher.group(2);
        return new PushNotificationTarget(PushNotificationTargetType.getTargetType(prefixIsFieldName), target);
    }
}

