/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheHandlerTask;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheContext;

public class RedisCacheHandler
implements CacheHandler {
    private CacheStore cs;

    public RedisCacheHandler(CacheStore cs) {
        this.cs = cs;
    }

    @SafeVarargs
    public final <K, V, R> List<? extends Future<R>> executeParallel(CacheHandlerTask<K, V, R> task, K ... inputKeys) {
        task.setContext(new RedisCacheContext(this.cs), inputKeys != null && inputKeys.length > 0 ? new HashSet<K>(Arrays.asList(inputKeys)) : Collections.emptySet());
        ArrayList ret = new ArrayList();
        try {
            Object r = task.call();
            ret.add(new SyncFuture(r, null));
        }
        catch (Exception e) {
            ret.add(new SyncFuture(null, e));
        }
        return ret;
    }

    private static class SyncFuture<R>
    implements Future<R> {
        private R result;
        private Exception e;

        private SyncFuture(R result, Exception e) {
            this.result = result;
            this.e = e;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            if (this.e != null) {
                throw new ExecutionException(this.e);
            }
            return this.result;
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

