/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class NamespaceHandler {
    private final String namespace;
    private final String prefix;
    private final byte[] binaryPrefix;

    public NamespaceHandler(String namespace) {
        this.namespace = namespace;
        this.prefix = namespace + ":";
        this.binaryPrefix = this.prefix.getBytes(StandardCharsets.UTF_8);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public byte[] getBinaryPrefix() {
        return this.binaryPrefix;
    }

    public String add(String key) {
        return key == null ? null : this.prefix + key;
    }

    public byte[] add(byte[] key) {
        return key == null ? null : ArrayUtils.addAll((byte[])this.binaryPrefix, (byte[])key);
    }

    public String remove(String key) {
        if (key != null && key.startsWith(this.prefix)) {
            key = key.substring(this.prefix.length());
        }
        return key;
    }

    public byte[] remove(byte[] key) {
        if (key != null && key.length >= this.binaryPrefix.length && Arrays.equals(this.binaryPrefix, Arrays.copyOf(key, this.binaryPrefix.length))) {
            key = Arrays.copyOfRange(key, this.binaryPrefix.length, key.length);
        }
        return key;
    }
}

