/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.redis.cache.store.NamespaceSerializedObjectCodec;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreBase;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheStore
extends RedisCacheStoreBase {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheStore.class);
    private StatefulRedisConnection<String, Object> redisConn;
    private RedisCommands<String, Object> redisCmds;
    private StatefulRedisPubSubConnection<String, String> psConn;
    private RedisPubSubCommands<String, String> psCmds;
    private NamespaceSerializedObjectCodec codec;

    public RedisCacheStore(RedisCacheStoreFactory factory, String namespace, long timeToLive, boolean isSave) {
        super(factory, namespace, timeToLive, isSave);
        this.codec = new NamespaceSerializedObjectCodec(namespace);
        this.redisConn = factory.getClient().connect((RedisCodec)this.codec);
        this.redisCmds = this.redisConn.sync();
        this.psConn = factory.getClient().connectPubSub();
        this.psConn.addListener((RedisPubSubListener)new RedisPubSubListener<String, String>(){

            public void unsubscribed(String channel, long count) {
            }

            public void subscribed(String channel, long count) {
            }

            public void punsubscribed(String pattern, long count) {
            }

            public void psubscribed(String pattern, long count) {
            }

            public void message(String pattern, String channel, String message) {
            }

            public void message(String channel, String message) {
                String prefix = RedisCacheStore.this.codec.getNamespaceHandler().getPrefix();
                if (message.startsWith(prefix)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Occuer expired event. channel:%s, message:%s", channel, message));
                    }
                    Object key = RedisCacheStore.this.decodeBase64(message.substring(prefix.length()));
                    RedisCacheStore.this.notifyRemoved(new CacheEntry(key, null, new Object[0]));
                }
            }
        });
        this.psCmds = this.psConn.sync();
        this.psCmds.subscribe((Object[])new String[]{"__keyevent@0__:expired"});
    }

    private boolean isExist(RedisCommands<String, Object> readCmds, String ... keys) {
        return readCmds.exists((Object[])keys).compareTo(0L) > 0;
    }

    CacheEntry put(RedisCommands<String, Object> readCmds, CacheEntry entry, boolean doExec) {
        String strKey = this.encodeBase64(entry.getKey());
        this.watch(strKey);
        CacheEntry previous = (CacheEntry)readCmds.get((Object)strKey);
        this.multi();
        if (this.getTimeToLive() > 0L) {
            this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
        } else {
            this.redisCmds.set((Object)strKey, (Object)entry);
        }
        if (doExec) {
            this.exec();
        }
        return previous;
    }

    public CacheEntry put(CacheEntry entry, boolean clean) {
        CacheEntry previous = this.put(this.redisCmds, entry, true);
        if (previous == null) {
            this.notifyPut(entry);
        } else {
            this.notifyUpdated(previous, entry);
        }
        return previous;
    }

    CacheEntry putIfAbsent(RedisCommands<String, Object> readCmds, CacheEntry entry, boolean doExec) {
        String strKey = this.encodeBase64(entry.getKey());
        this.watch(strKey);
        CacheEntry previous = (CacheEntry)readCmds.get((Object)strKey);
        if (previous == null) {
            this.multi();
            if (this.getTimeToLive() > 0L) {
                this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
            } else {
                this.redisCmds.set((Object)strKey, (Object)entry);
            }
            if (doExec) {
                this.exec();
            }
        } else {
            this.unwatch();
        }
        return previous;
    }

    public CacheEntry putIfAbsent(CacheEntry entry) {
        CacheEntry previous = this.putIfAbsent(this.redisCmds, entry, true);
        if (previous == null) {
            this.notifyPut(entry);
        }
        return previous;
    }

    public CacheEntry get(Object key) {
        return key != null ? (CacheEntry)this.redisCmds.get((Object)this.encodeBase64(key)) : null;
    }

    private CacheEntry remove(RedisCommands<String, Object> readCmds, String key, boolean doExec) {
        this.watch(key);
        if (this.isExist(readCmds, key)) {
            CacheEntry previous = (CacheEntry)readCmds.get((Object)key);
            this.multi();
            this.redisCmds.del((Object[])new String[]{key});
            if (doExec) {
                this.exec();
            }
            return previous;
        }
        this.unwatch();
        return null;
    }

    CacheEntry remove(RedisCommands<String, Object> readCmds, Object key, boolean doExec) {
        if (key == null) {
            return null;
        }
        CacheEntry previous = this.remove(readCmds, this.encodeBase64(key), doExec);
        return previous;
    }

    public CacheEntry remove(Object key) {
        CacheEntry previous = this.remove(this.redisCmds, key, true);
        if (previous != null) {
            this.notifyRemoved(previous);
        }
        return previous;
    }

    CacheEntry remove(RedisCommands<String, Object> readCmds, CacheEntry entry, boolean doExec) {
        CacheEntry previous;
        String strKey = this.encodeBase64(entry.getKey());
        this.watch(strKey);
        if (this.isExist(readCmds, strKey) && (previous = (CacheEntry)readCmds.get((Object)strKey)) != null && previous.equals((Object)entry)) {
            this.multi();
            this.redisCmds.del((Object[])new String[]{strKey});
            if (doExec) {
                this.exec();
            }
            return previous;
        }
        this.unwatch();
        return null;
    }

    public boolean remove(CacheEntry entry) {
        CacheEntry previous = this.remove(this.redisCmds, entry, true);
        if (previous != null && previous.equals((Object)entry)) {
            this.notifyRemoved(previous);
            return true;
        }
        return false;
    }

    CacheEntry replace(RedisCommands<String, Object> readCmds, CacheEntry entry, boolean doExec) {
        String strKey = this.encodeBase64(entry.getKey());
        this.watch(strKey);
        if (this.isExist(readCmds, strKey)) {
            CacheEntry preEntry = (CacheEntry)readCmds.get((Object)strKey);
            this.multi();
            if (this.getTimeToLive() > 0L) {
                this.redisCmds.setex((Object)strKey, this.getTimeToLive(), (Object)entry);
            } else {
                this.redisCmds.set((Object)strKey, (Object)entry);
            }
            if (doExec) {
                this.exec();
            }
            return preEntry;
        }
        this.unwatch();
        return null;
    }

    public CacheEntry replace(CacheEntry entry) {
        CacheEntry previous = this.replace(this.redisCmds, entry, true);
        if (previous != null) {
            this.notifyUpdated(previous, entry);
        }
        return previous;
    }

    boolean replace(RedisCommands<String, Object> readCmds, CacheEntry oldEntry, CacheEntry newEntry, boolean doExec) {
        if (!oldEntry.getKey().equals(newEntry.getKey())) {
            throw new IllegalArgumentException("oldEntry key not equals newEntry key");
        }
        String strKey = this.encodeBase64(newEntry.getKey());
        this.watch(strKey);
        if (this.isExist(readCmds, strKey) && oldEntry.equals(readCmds.get((Object)strKey))) {
            return this.replace(readCmds, newEntry, doExec) != null;
        }
        this.unwatch();
        return false;
    }

    public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
        boolean previous = this.replace(this.redisCmds, oldEntry, newEntry, true);
        if (previous) {
            this.notifyUpdated(oldEntry, newEntry);
        }
        return previous;
    }

    public void removeAll() {
        if (this.hasListener()) {
            this.keySet().forEach(key -> this.remove(key));
        } else {
            List keys = this.redisCmds.keys((Object)"*");
            if (keys != null && !keys.isEmpty()) {
                this.redisCmds.del((Object[])keys.toArray(new String[keys.size()]));
            }
        }
    }

    public List<Object> keySet() {
        List keys = this.redisCmds.keys((Object)"*");
        if (keys != null && !keys.isEmpty()) {
            ArrayList<Object> keyList = new ArrayList<Object>();
            keys.forEach(key -> keyList.add(this.decodeBase64((String)key)));
            return keyList;
        }
        return Collections.emptyList();
    }

    public CacheEntry getByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
        return null;
    }

    public String trace() {
        return this.redisCmds.info();
    }

    public void destroy() {
        if (this.psCmds != null && this.psCmds.isOpen()) {
            this.psCmds.unsubscribe((Object[])new String[]{"__keyevent@0__:expired"});
            this.psCmds.shutdown(false);
            this.psCmds = null;
        }
        if (this.psConn != null && this.psConn.isOpen()) {
            this.psConn.close();
            this.psConn = null;
        }
        if (this.redisCmds != null && this.redisCmds.isOpen()) {
            this.redisCmds.shutdown(this.isSave());
            this.redisCmds = null;
        }
        if (this.redisConn != null && this.redisConn.isOpen()) {
            this.redisConn.close();
            this.redisConn = null;
        }
    }

    NamespaceSerializedObjectCodec getCodec() {
        return this.codec;
    }

    void addPubSubListener(RedisPubSubListener<String, String> listener) {
        this.psConn.addListener(listener);
    }

    String multi() {
        return this.redisCmds.multi();
    }

    TransactionResult exec() {
        return this.redisCmds.exec();
    }

    String discard() {
        return this.redisCmds.discard();
    }

    String watch(String ... keys) {
        return this.redisCmds.watch((Object[])keys);
    }

    String unwatch() {
        return this.redisCmds.unwatch();
    }

    Long lrem(String key, long count, Object value) {
        return this.redisCmds.lrem((Object)key, count, value);
    }

    Long rpush(String key, Object ... values) {
        return this.redisCmds.rpush((Object)key, values);
    }
}

