/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import io.lettuce.core.codec.RedisCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.iplass.mtp.impl.redis.cache.store.NamespaceHandler;

public class NamespaceSerializedObjectCodec
implements RedisCodec<String, Object> {
    private final Charset charset = Charset.forName("UTF-8");
    private final NamespaceHandler nsHandler;

    public NamespaceSerializedObjectCodec(String namespace) {
        this.nsHandler = new NamespaceHandler(namespace);
    }

    public NamespaceHandler getNamespaceHandler() {
        return this.nsHandler;
    }

    public String decodeKey(ByteBuffer bytes) {
        return this.nsHandler.remove(this.charset.decode(bytes).toString());
    }

    public Object decodeValue(ByteBuffer bytes) {
        try {
            byte[] array = new byte[bytes.remaining()];
            bytes.get(array);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(array));
            return is.readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteBuffer encodeKey(String key) {
        return this.charset.encode(this.nsHandler.add(key));
    }

    public ByteBuffer encodeValue(Object value) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bytes);
            os.writeObject(value);
            return ByteBuffer.wrap(bytes.toByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }
}

