/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.redis.cache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.MtpException;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.event.CacheCreateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheRemoveEvent;
import org.iplass.mtp.impl.cache.store.event.CacheUpdateEvent;
import org.iplass.mtp.impl.redis.cache.store.RedisCacheStoreFactory;

public abstract class RedisCacheStoreBase
implements CacheStore {
    private final RedisCacheStoreFactory factory;
    private final String namespace;
    private final long timeToLive;
    private final boolean isSave;
    private List<CacheEventListener> listeners;

    public RedisCacheStoreBase(RedisCacheStoreFactory factory, String namespace, long timeToLive, boolean isSave) {
        this.factory = factory;
        this.namespace = namespace;
        this.timeToLive = timeToLive;
        this.isSave = isSave;
        this.listeners = new CopyOnWriteArrayList<CacheEventListener>();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CacheStoreFactory getFactory() {
        return this.factory;
    }

    public void addCacheEventListenner(CacheEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeCacheEventListenner(CacheEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<CacheEventListener> getListeners() {
        return this.listeners;
    }

    protected long getTimeToLive() {
        return this.timeToLive;
    }

    protected boolean isSave() {
        return this.isSave;
    }

    protected void notifyRemoved(CacheEntry entry) {
        if (this.listeners != null) {
            CacheRemoveEvent e = new CacheRemoveEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.removed(e);
            }
        }
    }

    protected void notifyPut(CacheEntry entry) {
        if (this.listeners != null) {
            CacheCreateEvent e = new CacheCreateEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.created(e);
            }
        }
    }

    protected void notifyUpdated(CacheEntry preEntry, CacheEntry entry) {
        if (this.listeners != null) {
            CacheUpdateEvent e = new CacheUpdateEvent(preEntry, entry);
            for (CacheEventListener l : this.listeners) {
                l.updated(e);
            }
        }
    }

    protected void notifyInvalidated(CacheEntry entry) {
        if (this.listeners != null) {
            CacheInvalidateEvent e = new CacheInvalidateEvent(entry);
            for (CacheEventListener l : this.listeners) {
                l.invalidated(e);
            }
        }
    }

    protected boolean hasListener() {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.size() > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String encodeBase64(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream bis = new ObjectOutputStream(baos);){
            bis.writeObject(obj);
            bis.flush();
            String string = Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new MtpException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object decodeBase64(String src) {
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(src));
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new MtpException((Throwable)e);
        }
    }
}

